/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.adt.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.DynamicIdentifiableIterator;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.SchemeItemListImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeEvent;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.beans.notification.impl.IdentifiableChangeEventImpl;

public class ResolvingSchemeItemListImpl<B extends IdentifiableBean>
extends SchemeItemListImpl<B> {
    private Set<String> urnSet = new LinkedHashSet<String>();

    public ResolvingSchemeItemListImpl(String maintainableUrn, Class<? extends B> beanClass, MutableBeanInitializer beanInitializer, DdiBeanFactory beanFactory, ChangeListener listener) {
        super(maintainableUrn, beanClass, beanInitializer, beanFactory, listener);
    }

    @Override
    public void initAddIdentifiableUrn(String urn) {
        this.urnSet.add(urn);
    }

    @Override
    public void initSetIdentifiableUrns(String[] urns) {
        String[] stringArray = urns;
        int n = urns.length;
        int n2 = 0;
        while (n2 < n) {
            String urn = stringArray[n2];
            this.urnSet.add(urn);
            ++n2;
        }
    }

    @Override
    public void initAddIdentifiableBean(B bean) {
        this.urnSet.add(bean.getUrn());
    }

    @Override
    public void initSetIdentifiableBeans(B[] beans) {
        B[] BArray = beans;
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            B bean = BArray[n2];
            this.urnSet.add(bean.getUrn());
            ++n2;
        }
    }

    @Override
    protected boolean add(B bean) {
        if (!this.urnSet.contains(bean.getUrn())) {
            boolean result = this.urnSet.add(bean.getUrn());
            return result;
        }
        return false;
    }

    @Override
    public Iterator<B> iterator() {
        return new DynamicIdentifiableIterator(this.urnSet, this.getBeanClass(), this.getResolver());
    }

    @Override
    public boolean contains(B bean) {
        return this.urnSet.contains(bean.getUrn());
    }

    @Override
    public boolean remove(B bean) {
        boolean result = this.urnSet.remove(bean.getUrn());
        if (result) {
            IdentifiableBean[] identifiableBeanArray = bean.getReferrers();
            int n = identifiableBeanArray.length;
            int n2 = 0;
            while (n2 < n) {
                IdentifiableBean referrer = identifiableBeanArray[n2];
                referrer.removeReference((IdentifiableBean)bean);
                ++n2;
            }
        }
        this.notifyChange((ChangeEvent)new IdentifiableChangeEventImpl(ChangeEvent.Type.DELETE, bean, new ChangeEvent[0]));
        return result;
    }

    @Override
    public void moveBefore(B move, B before) {
        LinkedHashSet<String> tmpSet = new LinkedHashSet<String>();
        tmpSet.addAll(this.urnSet);
        this.urnSet.clear();
        for (String urn : tmpSet) {
            if (urn.equals(move.getUrn())) continue;
            if (urn.equals(before.getUrn())) {
                this.urnSet.add(move.getUrn());
            }
            this.urnSet.add(urn);
        }
        this.ddiBeanChanged();
    }

    @Override
    public void moveAfter(B move, B after) {
        LinkedHashSet<String> tmpSet = new LinkedHashSet<String>();
        tmpSet.addAll(this.urnSet);
        this.urnSet.clear();
        for (String urn : tmpSet) {
            if (urn.equals(move.getUrn())) continue;
            this.urnSet.add(urn);
            if (!urn.equals(after.getUrn())) continue;
            this.urnSet.add(move.getUrn());
        }
        this.ddiBeanChanged();
    }

    @Override
    public int size() {
        return this.urnSet.size();
    }

    @Override
    public void sort(Comparator<B> comparator) {
        IdentifiableBean[] tmpArr = this.toArray();
        List<IdentifiableBean> tmpList = Arrays.asList(tmpArr);
        Collections.sort(tmpList, comparator);
        this.urnSet.clear();
        for (IdentifiableBean bean : tmpList) {
            this.urnSet.add(bean.getUrn());
        }
        this.ddiBeanChanged();
    }

    private List<B> getTempList() {
        ArrayList<IdentifiableBean> list = new ArrayList<IdentifiableBean>();
        for (String urn : this.urnSet) {
            try {
                IdentifiableBean bean = (IdentifiableBean)this.getResolver().resolve(this.getBeanClass(), urn);
                list.add(bean);
            }
            catch (ResolverException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    @Override
    public B[] toArray() {
        IdentifiableBean[] typeArr = (IdentifiableBean[])Array.newInstance(this.getBeanClass(), 0);
        return this.getTempList().toArray(typeArr);
    }

    @Override
    public String[] getUrns() {
        return this.urnSet.toArray(new String[0]);
    }
}

