/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.adt.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openmetadata.beans.ddi.lifecycle.adt.ReferenceSet;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;

public abstract class CompositeReferenceSetImpl<B extends IdentifiableBean>
implements ReferenceSet<B> {
    private List<ReferenceSet<? extends B>> refSetList = new ArrayList<ReferenceSet<? extends B>>();

    public CompositeReferenceSetImpl(ReferenceSet<? extends B> ... sets) {
        ReferenceSet<? extends B>[] referenceSetArray = sets;
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            ReferenceSet<? extends B> set = referenceSetArray[n2];
            this.refSetList.add(set);
            ++n2;
        }
    }

    @Override
    public Iterator<B> iterator() {
        ArrayList<IdentifiableBean> superList = new ArrayList<IdentifiableBean>();
        for (ReferenceSet<B> set : this.refSetList) {
            for (IdentifiableBean bean : set) {
                superList.add(bean);
            }
        }
        return superList.iterator();
    }

    @Override
    public boolean contains(B bean) {
        for (ReferenceSet<B> set : this.refSetList) {
            if (!set.contains(bean.getUrn())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(String urn) {
        for (ReferenceSet<B> set : this.refSetList) {
            if (!set.contains(urn)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(B bean) {
        for (ReferenceSet<B> set : this.refSetList) {
            if (!set.contains(bean.getUrn())) continue;
            set.remove(bean.getUrn());
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(String urn) {
        for (ReferenceSet<B> set : this.refSetList) {
            if (!set.contains(urn)) continue;
            set.remove(urn);
            return true;
        }
        return false;
    }

    @Override
    public B[] toArray(B[] arr) {
        ArrayList<IdentifiableBean> superList = new ArrayList<IdentifiableBean>();
        for (ReferenceSet<B> set : this.refSetList) {
            for (IdentifiableBean bean : set) {
                superList.add(bean);
            }
        }
        return (IdentifiableBean[])superList.toArray(arr);
    }

    @Override
    public int size() {
        int total = 0;
        for (ReferenceSet<B> set : this.refSetList) {
            total += set.size();
        }
        return total;
    }
}

