package org.openmetadata.beans.ddi.lifecycle.physicalinstance.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.URIBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.notification.ChangeListener;

public class URIBeanImpl extends UnsettableDdiBeanImpl implements URIBean {
	private static boolean IS_PUBLIC_DEFAULT = true;

	Boolean isPublic = null;
	String strVal = null;

	public URIBeanImpl(DdiBeanFactory factory, ChangeListener listener) {
		super(factory, listener);
		isPublic = null;
		strVal = null;
	}

	@Override
	public boolean isSetPublic() {
		return this.isPublic != null;
	}

	@Override
	public boolean isPublic() {
		if (this.isPublic != null) {
			return this.isPublic;
		} else {
			return IS_PUBLIC_DEFAULT;
		}
	}

	@Override
	public void setPublic(boolean value) {
		this.isPublic = value;
	}

	@Override
	public String getStringValue() {
		if (strVal != null) {
			return strVal;
		} else {
			return "";
		}
	}

	@Override
	public void setStringValue(String value) {
		if (CompareUtil.areDifferentValues(strVal, value)) {
			strVal = value;
			this.ddiBeanChanged();
		}
	}

	@Override
	protected boolean internalIsSet() {
		return !StringUtils.isEmpty(strVal);
	}

	/*
	 * @Override public URIType getDdi3XmlObject() throws DdiValidationException
	 * { URIType ut = super.getDdi3XmlObject(); if(isPublic!=null){
	 * ut.setIsPublic(isPublic()); }
	 * 
	 * if(strVal!=null){ ut.setStringValue(strVal); }else{
	 * ut.setStringValue(""); }
	 * 
	 * return ut; }
	 * 
	 * @Override protected URIType createDdi3XmlObject() { return
	 * URIType.Factory.newInstance(); }
	 * 
	 * @Override protected SchemaType getSchemaType() { return URIType.type; }
	 */

}
