package org.openmetadata.beans.ddi.lifecycle.physicalinstance.impl;

import java.util.ArrayList;
import java.util.List;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.DdiBeanListImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.DataFileIdentificationBean;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.PathBean;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.URIBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractIdentifiableBeanImpl;
import org.openmetadata.ddi_3_1.util.URN;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.openmetadata.beans.impl.MutableBeanInitializer;

public class DataFileIdentificationBeanImpl extends
		AbstractIdentifiableBeanImpl implements DataFileIdentificationBean {

	private Boolean isMaster = null;

	private List<String> locationList;

	private final DdiBeanListImpl<PathBean> pathList;
	private final DdiBeanListImpl<URIBean> uriList;

	public DataFileIdentificationBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);
		isMaster = null;
		locationList = new ArrayList<String>();

		pathList = new DdiBeanListImpl<PathBean>(PathBean.class, beanInitializer, factory, this) {
			@Override
			protected PathBean createNew() {
				return new PathBeanImpl(
						DataFileIdentificationBeanImpl.this.getBeanFactory(),
						DataFileIdentificationBeanImpl.this);
			}
		};

		uriList = new DdiBeanListImpl<URIBean>(URIBean.class, beanInitializer, factory, this) {
			@Override
			protected URIBean createNew() {
				return new URIBeanImpl(
						DataFileIdentificationBeanImpl.this.getBeanFactory(),
						DataFileIdentificationBeanImpl.this);
			}
		};
	}

	/*
	 * private DdiBeanListImpl<PathBeanImpl, PathBean, PathType>
	 * createPathList(List<PathType> list){ return new
	 * DdiBeanListImpl<PathBeanImpl, PathBean, PathType>(list,
	 * this.getBeanChangedListener()){
	 * 
	 * @Override public PathBean createNew() { return new
	 * PathBeanImpl(this.getBeanChangedListener()); }
	 * 
	 * @Override public PathBean createNew(PathType xmlObject) { return new
	 * PathBeanImpl(xmlObject, this.getBeanChangedListener()); } }; } private
	 * DdiBeanListImpl<URIBeanImpl, URIBean, URIType>
	 * createUriList(List<URIType> list){ return new
	 * DdiBeanListImpl<URIBeanImpl, URIBean, URIType>(list,
	 * this.getBeanChangedListener()){
	 * 
	 * @Override public URIBean createNew() { return new
	 * URIBeanImpl(this.getBeanChangedListener()); }
	 * 
	 * @Override public URIBean createNew(URIType xmlObject) { return new
	 * URIBeanImpl(xmlObject, this.getBeanChangedListener()); } }; }
	 */

	@Override
	public boolean isSetIsMaster() {
		return isMaster != null;
	}

	@Override
	public void setIsMaster(boolean value) {
		if (CompareUtil.areDifferentValues(this.isMaster, value)) {
			isMaster = value;
			this.change();
		}
	}

	@Override
	public boolean getIsMaster() {
		if (isMaster != null) {
			return isMaster;
		} else {
			return false;
		}
	}

	@Override
	public List<String> getLocation() {
		return locationList;
	}

	@Override
	public DdiBeanListImpl<PathBean> getPath() {
		return pathList;
	}

	@Override
	public DdiBeanListImpl<URIBean> getURI() {
		return uriList;
	}

	/*
	 * @Override public DataFileIdentificationType getDdi3XmlObject() throws
	 * DdiValidationException { DataFileIdentificationType dfi =
	 * super.getDdi3XmlObject();
	 * 
	 * if(isSetIsMaster()){ dfi.setIsMaster(this.getIsMaster()); }
	 * 
	 * dfi.getLocationList().clear(); for(String location: getLocation()){
	 * dfi.getLocationList().add(location); }
	 * 
	 * dfi.getPathList().clear();
	 * dfi.getPathList().addAll(getPath().getDdi3XmlObjectList());
	 * 
	 * dfi.getURIList().clear();
	 * dfi.getURIList().addAll(getURI().getDdi3XmlObjectList());
	 * 
	 * return dfi; }
	 * 
	 * @Override protected DataFileIdentificationType createDdi3XmlObject() {
	 * return DataFileIdentificationType.Factory.newInstance(); }
	 * 
	 * @Override protected SchemaType getSchemaType() { return
	 * DataFileIdentificationType.type; }
	 * 
	 * @Override protected List<NameType> getXmlName(DataFileIdentificationType
	 * xmlObject) { return new ArrayList<NameType>(); }
	 * 
	 * @Override protected List<LabelType>
	 * getXmlLabel(DataFileIdentificationType xmlObject) { return new
	 * ArrayList<LabelType>(); }
	 * 
	 * @Override protected List<StructuredStringType> getXmlDescription(
	 * DataFileIdentificationType xmlObject) { return new
	 * ArrayList<StructuredStringType>(); }
	 * 
	 * @Override protected void setXmlName(DataFileIdentificationType xmlObject)
	 * throws DdiValidationException { // do nothing }
	 * 
	 * @Override protected void setXmlLabel(DataFileIdentificationType
	 * xmlObject) throws DdiValidationException { // do nothing }
	 * 
	 * @Override protected void setXmlDescription(DataFileIdentificationType
	 * xmlObject) throws DdiValidationException { // do nothing }
	 */

	@Override
	public void doChangeReference(IdentifiableBean current,
			IdentifiableBean another) {

	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		// TODO Auto-generated method stub

	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.DataFileIdentification;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return DataFileIdentificationBean.class;
	}
}
