package org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableSpecificationReferenceSet;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.ddi.util.exceptions.URNFormatException;
import org.openmetadata.beans.notification.ChangeListener;

public class VariableSpecificationReferenceSetImpl extends
		UnsettableDdiBeanImpl implements VariableSpecificationReferenceSet {

	private Map<String, VariableSpecificationReferenceBeanImpl> map = new HashMap<String, VariableSpecificationReferenceBeanImpl>();

	public VariableSpecificationReferenceSetImpl(DdiBeanFactory factory,
			ChangeListener listener) {
		super(factory, listener);
	}

	public void initSetVariableUrns(String[] variableUrns)
			throws URNFormatException {
		for (String variableUrn : variableUrns) {
			VariableSpecificationReferenceBeanImpl varSpecRef = new VariableSpecificationReferenceBeanImpl(
					this.getBeanFactory(), this);
			varSpecRef.initSetVariableUrn(variableUrn);
			map.put(variableUrn, varSpecRef);
		}
	}

	@Override
	public Iterator<VariableBean> iterator() {
		List<VariableBean> varList = new ArrayList<VariableBean>();
		for (VariableSpecificationReferenceBeanImpl varSpecRef : map.values()) {
			VariableBean variable = varSpecRef.getVariable();
			varList.add(variable);
		}
		return varList.iterator();
	}

	@Override
	public boolean contains(VariableBean bean) {
		if (bean != null) {
			return map.containsKey(bean.getUrn());
		} else {
			return false;
		}
	}

	@Override
	public boolean contains(String urn) {
		if (urn != null) {
			return map.containsKey(urn);
		} else {
			return false;
		}
	}

	@Override
	public boolean add(VariableBean bean) {
		if (this.contains(bean) == false && bean != null) {
			VariableSpecificationReferenceBeanImpl varSpecRef = new VariableSpecificationReferenceBeanImpl(
					this.getBeanFactory(), this);
			try {
				varSpecRef.initSetVariableUrn(bean.getUrn());
				map.put(bean.getUrn(), varSpecRef);
				return true;
			} catch (URNFormatException e) {
				return false;
			}
		} else {
			return false;
		}
	}

	@Override
	public boolean remove(VariableBean bean) {
		if (bean != null && map.containsKey(bean.getUrn())) {
			map.remove(bean.getUrn());
			return true;
		} else {
			return false;
		}
	}

	@Override
	public boolean remove(String urn) {
		if (urn != null && map.containsKey(urn)) {
			map.remove(urn);
			return true;
		} else {
			return false;
		}
	}

	@Override
	public VariableBean[] toArray(VariableBean[] arr) {
		List<VariableBean> varList = new ArrayList<VariableBean>();
		for (VariableSpecificationReferenceBeanImpl varSpecRef : map.values()) {
			VariableBean variable = varSpecRef.getVariable();
			varList.add(variable);
		}
		return varList.toArray(arr);
	}

	@Override
	public int size() {
		return map.size();
	}

	@Override
	public String[] getUrns() {
		return map.keySet().toArray(new String[0]);
	}

	@Override
	public void clear() {
		map.clear();
	}

	@Override
	protected boolean internalIsSet() {
		return map.isEmpty()==false;
	}	
	
	@Override
	public void moveBefore(VariableBean move, VariableBean before) {
		Map<String, VariableSpecificationReferenceBeanImpl> tmpMap = 
			new LinkedHashMap<String, VariableSpecificationReferenceBeanImpl>();
		tmpMap.putAll(map);
		
		map.clear();
		for(String urn : tmpMap.keySet()){
			if(urn.equals(move.getUrn()) == false){
				if(urn.equals(before.getUrn())){
					map.put(move.getUrn(), tmpMap.get(move.getUrn()));					
				}
				map.put(urn, tmpMap.get(urn));
			}
		}
		this.ddiBeanChanged();
	}

	@Override
	public void moveAfter(VariableBean move, VariableBean after) {
		Map<String, VariableSpecificationReferenceBeanImpl> tmpMap = 
			new LinkedHashMap<String, VariableSpecificationReferenceBeanImpl>();
		tmpMap.putAll(map);
		
		map.clear();
		for(String urn : tmpMap.keySet()){
			if(urn.equals(move.getUrn()) == false){				
				map.put(urn, tmpMap.get(urn));
				if(urn.equals(after.getUrn())){
					map.put(move.getUrn(), tmpMap.get(move.getUrn()));	
				}
			}
		}
		this.ddiBeanChanged();
	}
}
