package org.openmetadata.beans.ddi.lifecycle.logicalproduct;

import org.openmetadata.beans.ddi.lifecycle.adt.ReferenceSet;
import org.openmetadata.beans.ddi.lifecycle.datacollection.CodingBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.DateTimeRepresentationBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.DateTypeCode;
import org.openmetadata.beans.ddi.lifecycle.reusable.ExternalCategoryRepresentationBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.NumericRepresentationBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.NumericTypeCode;
import org.openmetadata.beans.ddi.lifecycle.reusable.TextRepresentationBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.UnsettableDdiBean;
import org.openmetadata.beans.ddi.lifecycle.types.VariableRepresentationType;

public interface VariableRepresentationBean extends UnsettableDdiBean {

	String getMeasurementUnit();

	void setMeasurementUnit(String measurementUnit);

	boolean isSetMeasurementUnit();

	String getRole();

	void setRole(String role);

	boolean isSetRole();

	VariableRepresentationType getRepresentationType();

	boolean isCodeRepresentation();

	VariableCodeRepresentationBean getCodeRepresentation();

	VariableCodeRepresentationBean changeToCodeRepresentation(
			CodeSchemeBean codeScheme) ;

	// VariableCodeRepresentationBean changeToCodeRepresentation(String
	// codeSchemeUrn) throws URNFormatException;

	boolean isNumericRepresentation();

	NumericRepresentationBean getNumericRepresentation();

	NumericRepresentationBean changeToNumericRepresentation(
			NumericTypeCode numericType);

	boolean isTextRepresentation();

	TextRepresentationBean getTextRepresentation();

	TextRepresentationBean changeToTextRepresentation();

	boolean isExternalCategoryRepresentation();

	ExternalCategoryRepresentationBean getExternalCategoryRepresentation();

	ExternalCategoryRepresentationBean changeToExternalCategoryRepresentation();

	boolean isDateTimeRepresentation();

	DateTimeRepresentationBean getDateTimeRepresentation();

	DateTimeRepresentationBean changeToDateTimeRepresentation(
			DateTypeCode dateType);

	// public VariableRepresentationEnum getVariableRepresentationType();
	// public VariableDataType getVariableDataType();
	// public void changeVariableDataType(VariableDataType type);
	// public <T extends RepresentationBean> T changeRepresentation(Class<T>
	// typeClass);
	
	boolean isSetCodingInstruction();

	CodingBean getCodingInstruction();
	
	String getCodingInstructionUrn();
	
	void setCodingInstruction(CodingBean coding);
	
	void unsetCodingInstruction();
}