package org.openmetadata.beans.ddi.lifecycle.factory;

import org.openmetadata.beans.exceptions.FactoryException;
import org.openmetadata.beans.factory.impl.BeanFactoryImpl;
import org.openmetadata.beans.impl.IdentifiableBeanImpl;
import org.openmetadata.beans.notification.ChangeEvent.Type;
import org.openmetadata.beans.notification.impl.ConsolidatedEvent;
import org.openmetadata.beans.notification.impl.CreationEvent;

public class DdiBeanFactory extends BeanFactoryImpl {
	
	private DdiBeanImplementationConstructor implementationConstructor;
	
	public void setDdiBeanImplementationConstructor(
			DdiBeanImplementationConstructor implementationConstructor) {
		if (this.implementationConstructor != null
				&& !this.implementationConstructor
						.equals(implementationConstructor)) {
			String msg = "Implementation constructor cannot be reset.";
			logger.error(msg);
			throw new RuntimeException(msg);
		}
		this.implementationConstructor = implementationConstructor;
		
		this.setImplementationConstructor(implementationConstructor);
	}
	
	protected final DdiBeanImplementationConstructor getDdiBeanImplementationConstructor(){
		if (this.implementationConstructor == null) {
			String msg = "ImplementationConstructor has not been set.";
			logger.error(msg);
			throw new RuntimeException(msg);
		}
		return implementationConstructor;
	}
		
	public <B extends org.openmetadata.beans.IdentifiableBean> B newInstance(
			Class<B> beanClass, String parentUrn) throws FactoryException{
		
		setCollectChangeEvents(true);
		
		DdiBeanImplementationConstructor implConstructor = this.getDdiBeanImplementationConstructor();
		
		IdentifiableBeanImpl bean = implConstructor	.constructImplementation(beanClass, parentUrn);
		if (!bean.verifyInitializer(this)) {
			throw new RuntimeException(
					"Bean was not constructed properly: initializer has not been set as expected.");
		}		
		setCollectChangeEvents(false);
		// Make sure creation event exists for the new bean
		ConsolidatedEvent beanEvent = getConsolidatedEvent(bean);
		if (!beanEvent.getType().equals(Type.CREATE)) {
			beanEvent.addEvent(new CreationEvent(bean));
		}
		notifyChangeEvent(beanEvent);
		for (ConsolidatedEvent event : getConsolidatedEvents()) {
			notifyChangeEvent(event);
		}
		return castBean(beanClass, bean);
	}
}
