package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import org.openmetadata.beans.ddi.lifecycle.datacollection.TextBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.StructuredStringValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.notification.ChangeListener;

public abstract class TextBeanImpl extends UnsettableDdiBeanImpl implements
		TextBean {

	private final StructuredStringValueBeanImpl description;

	public TextBeanImpl(DdiBeanFactory factory, ChangeListener listener) {
		super(factory, listener);
		description = new StructuredStringValueBeanImpl(factory, this);
	}

	@Override
	public StructuredStringValueBeanImpl getDescription() {
		return description;
	}
	
	@Override
	protected boolean internalIsSet() {
		return description.isSet();
	}
}
