package org.openmetadata.beans.ddi.lifecycle.archive.impl;

import org.openmetadata.beans.ddi.lifecycle.archive.ArchiveBean;
import org.openmetadata.beans.ddi.lifecycle.archive.ArchiveSpecificBean;
import org.openmetadata.beans.ddi.lifecycle.archive.OrganizationBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.ddi.util.exceptions.URNFormatException;

public class ArchiveSpecificBeanImpl extends UnsettableDdiBeanImpl implements ArchiveSpecificBean{
	
	final ReferenceBeanImpl<OrganizationBean> organizationRef;

	public ArchiveSpecificBeanImpl(ArchiveBean archive, DdiBeanFactory factory, ChangeListener listener) {
		super(factory, listener);
		
		organizationRef = new ReferenceBeanImpl<OrganizationBean>(OrganizationBean.class, factory, this);
	}

	@Override
	public String getArchiveOrganizationUrn() {
		return organizationRef.getUrn();
	}

	@Override
	public OrganizationBean getArchiveOrganization() {
		try {
			return this.organizationRef.getReferredObject();
		} catch (ResolverException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}
	}

	public void setArchiveOrganizationUrn(String urn){
		try {
			this.organizationRef.setReferenceUrn(urn);
		} catch (URNFormatException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	@Override
	protected boolean internalIsSet() {
		return organizationRef.isSet();
	}

}
