package org.openmetadata.beans.ddi.lifecycle.archive;

import org.openmetadata.beans.ddi.lifecycle.adt.DdiBeanList;
import org.openmetadata.beans.ddi.lifecycle.reusable.CodeValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.ImageBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.InternationalStringValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.NoteBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.SchemeItemBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.StructuredStringValueBean;
import org.openmetadata.ddi_3_1.util.DdiClass;

public interface OrganizationBean extends
		SchemeItemBean<OrganizationSchemeBean> {
	
	public final static DdiClass ddiClass = DdiClass.Organization;
	
	StructuredStringValueBean getDescription();

	InternationalStringValueBean getNickname();

	DdiBeanList<DDIMaintenanceAgencyIDBean> getDDIMaintenanceAgencyIDList();

	InternationalStringValueBean getKeyword();

	DdiBeanList<LocationBean> getLocationList();

	DdiBeanList<TelephoneBean> getTelephoneList();

	DdiBeanList<URLBean> getURLList();

	DdiBeanList<EmailBean> getEmailList();

	DdiBeanList<InstantMessagingBean> getInstantMessagingList();

	CodeValueBean getRegionalCoverage();

	DdiBeanList<NoteBean> getNoteList();

	DdiBeanList<IndividualBean> getIndividuals();

	// TODO add relation list

	DdiBeanList<ImageBean> getImageList();

	// TODO add version distinction list
}
