package org.openmetadata.beans.ddi.lifecycle.adt.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.DdiBeanImpl;
import org.openmetadata.beans.exceptions.FactoryException;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.beans.notification.impl.CreationEvent;
import org.openmetadata.ddi_3_1.util.URN;

public abstract class SchemeItemListImpl<B extends IdentifiableBean> extends
		DdiBeanImpl implements InitializingSchemeItemList<B> {

	private final String maintainableUrn;
	private final Class<? extends B> beanClass;
	
	public SchemeItemListImpl(String maintainableUrn, Class<? extends B> beanClass,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory beanFactory, ChangeListener listener) {
		super(beanInitializer, beanFactory, listener);
		
		URN urn = URN.getURN(maintainableUrn);
		if(urn.hasParent()){
			throw new RuntimeException("Invalid maintianable urn is given : " + maintainableUrn);
		}		
		
		this.maintainableUrn = maintainableUrn;
		this.beanClass = beanClass;
	}
		
	protected abstract boolean add(B bean);
	
	@Override
	public final B addNew() {
		DdiBeanFactory beanFactory = this.getBeanFactory();
		try {
			B newBean = beanFactory.newInstance(this.getBeanClass(), this.getMaintainableUrn());
			this.add(newBean);
			this.notifyChange(new CreationEvent(newBean));
			return newBean;
		} catch (FactoryException e) {
			e.printStackTrace();
			return null;
		}
	}

	protected String getMaintainableUrn() {
		return this.maintainableUrn;
	}
	
	protected Class<? extends B> getBeanClass(){
		return this.beanClass;
	}
}