package org.openmetadata.beans.ddi.lifecycle.reusable;

public interface LabelBean extends StructuredStringBean {

	/**
	 * Return true if a specific geographic location that is also included in
	 * the spatial coverage section is set.
	 * 
	 * @param locationaVariant
	 * @return
	 */
	boolean isSetLocationVariant();

	/**
	 * Returns a specific geographic location that is also included in the
	 * spatial coverage section. The value is the geographic code found in the
	 * GeographyCode element.
	 * 
	 * @return
	 */
	String getLocationVariant();

	/**
	 * Sets a specific geographic location that is also included in the spatial
	 * coverage section. The value is the geographic code found in the
	 * GeographyCode element.
	 */
	void setLocationVariant(String locationVariant);

	/**
	 * Returns true if type, a value taken from a controlled vocabulary,
	 * describing the type of the label, is set.
	 * 
	 * @return
	 */
	boolean isSetType();

	/**
	 * Returns a value taken from a controlled vocabulary, describing the type
	 * of the label.
	 * 
	 * @return
	 */
	String getType();

	/**
	 * Sets a value taken from a controlled vocabulary, describing the type of
	 * the label.
	 * 
	 * @param type
	 */
	void setType(String type);

	// A positive integer indicating the maximum number of characters in the
	// label.
	boolean isSetMaxLength();

	int getMaxLength();

	void setMaxLength(int maxlength);

}
