package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import org.openmetadata.beans.ddi.lifecycle.adt.impl.DdiBeanListImpl;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.ControlConstructBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.GenerationInstructionBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.CommandBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.CommandBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.StructuredStringValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;

public class GenerationInstructionBeanImpl extends UnsettableDdiBeanImpl implements GenerationInstructionBean{
	public static final boolean IS_DERIVED_DEFAULT_RETURN_VALUE = false;
	
	private Boolean derived;
	private StructuredStringValueBeanImpl description;
	private DdiBeanListImpl<CommandBean> commandList;
	private ReferenceSetImpl<ControlConstructBean> controlConstructRefSet;
	private AggregationBeanImpl aggregation;

	public GenerationInstructionBeanImpl(
			final MutableBeanInitializer beanInitializer,
			DdiBeanFactory beanFactory,
			ChangeListener changeListener) {
		super(beanFactory, changeListener);
		
		description = new StructuredStringValueBeanImpl(beanFactory, this);
		
		commandList = new DdiBeanListImpl<CommandBean>(CommandBean.class, beanInitializer, beanFactory, this) {
			@Override
			protected CommandBean createNew() {
				return new CommandBeanImpl(GenerationInstructionBeanImpl.this.getBeanFactory(), GenerationInstructionBeanImpl.this);
			}
		};
		
		controlConstructRefSet = new ReferenceSetImpl<ControlConstructBean>(
				ControlConstructBean.class, beanInitializer, beanFactory, this);
		
		aggregation = new AggregationBeanImpl(beanFactory, this);
	}
	
	@Override
	public boolean getIsDerived() {
		if(this.derived != null){
			return this.derived;
		}
		return IS_DERIVED_DEFAULT_RETURN_VALUE;
	}

	@Override
	public boolean isSetIsDerived() {
		return this.derived != null;
	}

	@Override
	public void setIsDerived(boolean boo) {
		boolean applyChange = (this.derived!=null && this.derived!=boo) || (this.derived==null); 
		if(applyChange){
			this.derived = boo;
			ddiBeanChanged();
		}
	}

	@Override
	public void unsetIsDerived() {
		if(this.derived != null){
			this.derived = null;
			ddiBeanChanged();
		}
	}

	@Override
	public StructuredStringValueBeanImpl getDescription() {
		return description;
	}

	@Override
	public DdiBeanListImpl<CommandBean> getCommandList() {
		return commandList;
	}
	
	@Override
	public ReferenceSetImpl<ControlConstructBean> getContolConstructList() {
		return controlConstructRefSet;
	}

	@Override
	public AggregationBeanImpl getAggregation() {
		return aggregation;
	}

	@Override
	protected boolean internalIsSet() {
		return commandList.size() > 0 || description.getAllValues().length > 0;
	}
}
