package org.openmetadata.beans.ddi.lifecycle.archive.impl;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.DdiBeanListImpl;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ResolvingSchemeItemListImpl;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.SchemeItemListImpl;
import org.openmetadata.beans.ddi.lifecycle.archive.DDIMaintenanceAgencyIDBean;
import org.openmetadata.beans.ddi.lifecycle.archive.EmailBean;
import org.openmetadata.beans.ddi.lifecycle.archive.IndividualBean;
import org.openmetadata.beans.ddi.lifecycle.archive.InstantMessagingBean;
import org.openmetadata.beans.ddi.lifecycle.archive.LocationBean;
import org.openmetadata.beans.ddi.lifecycle.archive.OrganizationBean;
import org.openmetadata.beans.ddi.lifecycle.archive.OrganizationSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.archive.TelephoneBean;
import org.openmetadata.beans.ddi.lifecycle.archive.URLBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.ImageBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.NoteBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractSchemeItemBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.CodeValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ImageBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.InternationalStringValueBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.ddi_3_1.util.URN;

public class OrganizationBeanImpl extends
		AbstractSchemeItemBean<OrganizationSchemeBean> implements
		OrganizationBean {

	private SchemeItemListImpl<IndividualBean> individuals;
	private SchemeItemListImpl<NoteBean> noteList;

	private InternationalStringValueBeanImpl nickname;
	private InternationalStringValueBeanImpl keyword;
	private DdiBeanListImpl<DDIMaintenanceAgencyIDBean> ddiMaintenanceAgencyList;
	private SchemeItemListImpl<LocationBean> locationList;
	private DdiBeanListImpl<TelephoneBean> telephoneList;
	private DdiBeanListImpl<URLBean> urlList;
	private DdiBeanListImpl<EmailBean> emailList;
	private DdiBeanListImpl<InstantMessagingBean> instantMessagingList;
	private CodeValueBeanImpl regionalCoverage;

	private DdiBeanListImpl<ImageBean> imageList;

	public OrganizationBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);

		individuals = new ResolvingSchemeItemListImpl<IndividualBean>(
				urn.getParent().toString(), IndividualBean.class, beanInitializer, factory, this);

		noteList = new ResolvingSchemeItemListImpl<NoteBean>(urn.getParent().toString(),
				NoteBean.class, beanInitializer, factory, this);

		nickname = new InternationalStringValueBeanImpl(factory, this);
		keyword = new InternationalStringValueBeanImpl(factory, this);

		ddiMaintenanceAgencyList = new DdiBeanListImpl<DDIMaintenanceAgencyIDBean>(
				DDIMaintenanceAgencyIDBean.class, beanInitializer, factory, this) {
			@Override
			protected DDIMaintenanceAgencyIDBean createNew() {
				return new DDIMaintenanceAgencyIDBeanImpl(getBeanFactory(),
						this);
			}
		};

		locationList = new ResolvingSchemeItemListImpl<LocationBean>(
				urn.getParent().toString(), LocationBean.class, beanInitializer, factory, this);

		telephoneList = new DdiBeanListImpl<TelephoneBean>(TelephoneBean.class, beanInitializer, factory, this) {
			@Override
			protected TelephoneBean createNew() {
				return new TelephoneBeanImpl(getBeanFactory(), this);
			}
		};

		urlList = new DdiBeanListImpl<URLBean>(URLBean.class, beanInitializer, factory, this) {
			@Override
			protected URLBean createNew() {
				return new URLBeanImpl(getBeanFactory(), this);
			}
		};

		emailList = new DdiBeanListImpl<EmailBean>(EmailBean.class, beanInitializer, factory, this) {
			@Override
			protected EmailBean createNew() {
				return new EmailBeanImpl(getBeanFactory(), this);
			}
		};

		instantMessagingList = new DdiBeanListImpl<InstantMessagingBean>(
				InstantMessagingBean.class, beanInitializer, factory, this) {
			@Override
			protected InstantMessagingBean createNew() {
				return new InstantMessagingBeanImpl(getBeanFactory(), this);
			}
		};

		regionalCoverage = new CodeValueBeanImpl(factory, this);

		imageList = new DdiBeanListImpl<ImageBean>(ImageBean.class, beanInitializer, factory, this) {
			@Override
			protected ImageBean createNew() {
				return new ImageBeanImpl(getBeanFactory(), this);
			}
		};
	}

	@Override
	public SchemeItemListImpl<IndividualBean> getIndividuals() {
		return individuals;
	}

	@Override
	public InternationalStringValueBeanImpl getNickname() {
		return this.nickname;
	}

	@Override
	public InternationalStringValueBeanImpl getKeyword() {
		return this.keyword;
	}

	@Override
	public DdiBeanListImpl<DDIMaintenanceAgencyIDBean> getDDIMaintenanceAgencyIDList() {
		return this.ddiMaintenanceAgencyList;
	}

	@Override
	public SchemeItemListImpl<LocationBean> getLocationList() {
		return this.locationList;
	}

	@Override
	public DdiBeanListImpl<TelephoneBean> getTelephoneList() {
		return this.telephoneList;
	}

	@Override
	public DdiBeanListImpl<URLBean> getURLList() {
		return this.urlList;
	}

	@Override
	public DdiBeanListImpl<EmailBean> getEmailList() {
		return this.emailList;
	}

	@Override
	public DdiBeanListImpl<InstantMessagingBean> getInstantMessagingList() {
		return this.instantMessagingList;
	}

	@Override
	public CodeValueBeanImpl getRegionalCoverage() {
		return this.regionalCoverage;
	}

	@Override
	public SchemeItemListImpl<NoteBean> getNoteList() {
		return this.noteList;
	}

	@Override
	public DdiBeanListImpl<ImageBean> getImageList() {
		return this.imageList;
	}

	@Override
	public void doChangeReference(IdentifiableBean toDerefer,
			IdentifiableBean toRefer) {
		// TODO Auto-generated method stub
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		// TODO Auto-generated method stub
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.Organization;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return OrganizationBean.class;
	}

}
