package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.BaseDateBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.DateRangeBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.HistoricalDateBean;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;

public class DateRangeBeanImpl extends DdiBeanImpl implements DateRangeBean {

	private BaseDateBean startDateBean;
	private BaseDateBean endDateBean;
	private HistoricalDateBean hisStartDateBean;
	private HistoricalDateBean hisEndDateBean;
	private Integer cycles;

	public DateRangeBeanImpl(MutableBeanInitializer beanInitializer, DdiBeanFactory factory, ChangeListener listener) {
		super(beanInitializer, factory, listener);
		startDateBean = new BaseDateBeanImpl(factory, this);
		endDateBean = new BaseDateBeanImpl(factory, this);
		hisStartDateBean = new HistoricalDateBeanImpl(factory, this);
		hisEndDateBean = new HistoricalDateBeanImpl(factory, this);
	}

	@Override
	public BaseDateBean getStartDate() {
		return startDateBean;
	}

	@Override
	public BaseDateBean getEndDate() {
		return endDateBean;
	}

	@Override
	public HistoricalDateBean getHistoricalStartDate() {
		return hisStartDateBean;
	}

	@Override
	public HistoricalDateBean getHistoricalEndDate() {
		return hisEndDateBean;
	}

	@Override
	public boolean isSetCycle() {
		return cycles != null;
	}

	@Override
	public int getCycle() {
		if (cycles != null) {
			return cycles;
		} else {
			return 0;
		}
	}

	@Override
	public void setCycle(int cycle) {
		cycles = cycle;
		this.ddiBeanChanged();
	}

	@Override
	public boolean isSet() {
		return startDateBean.isSet();
	}

	@Override
	public void unset() {
		startDateBean.unset();
		endDateBean.unset();
		hisStartDateBean.unset();
		hisEndDateBean.unset();
		cycles = 0;
		this.ddiBeanChanged();
	}
}
