package org.openmetadata.beans.ddi.lifecycle.reusable;

import org.openmetadata.beans.ddi.lifecycle.adt.ResolvingSet;
import org.openmetadata.ddi_3_1.util.DdiClass;

public interface IdentifiableBean extends DdiBean,
		org.openmetadata.beans.IdentifiableBean {
	
	public final static DdiClass ddiClass = null;
	
	public AttributeSet getAttributeSet();
	
	public DdiClass getDdiClass();

	public abstract String getId();

	public abstract Class<? extends IdentifiableBean> getBeanType();

	public abstract boolean isSetUrn();

	public abstract String getUrn();

	public abstract boolean isSetObjectSource();

	public abstract String getObjectSource();

	public abstract void setObjectSource(String value);

	public abstract boolean isSetAction();

	public abstract ActionCode getAction();

	public abstract void setAction(ActionCode action);

	// public DdiClass getDefaultObjectSource();

	public abstract UserIDValueBean getUserIDValues();

	public abstract NameValueBean getName();

	public abstract LabelValueBean getLabel();

	public abstract StructuredStringValueBean getDescription();
	
	public abstract IdentifiableBean[] getReferrers();

	public abstract ResolvingSet<IdentifiableBean> getReferrerSet();

	/**
	 * Made the bean to remove the reference to the previously referred bean and
	 * point to another bean. To make the bean refer to nothing, pass null to
	 * the bean to be newly referred to.
	 * 
	 * The client of this method expect the following to happen.
	 * 
	 * if current is not null and currently referred by this identifiable bean -
	 * if another is not null, this identifiable bean will refer to another - if
	 * another is null, this identifiable bean will have empty reference else do
	 * nothing
	 * 
	 * @param current
	 *            currently referred bean that is to be dereferenced
	 * @param another
	 *            Bean to be referred. It can be null.
	 * @throws ReferenceException
	 */
	public abstract void changeReference(IdentifiableBean current,
			IdentifiableBean another) ;

	public abstract void removeReference(IdentifiableBean toRemove);

	// public void removeAllReferences();

	// public void madeReferrersPointTo(IdentifiableBean another);

	public abstract void copyNameLabelDescription(IdentifiableBean from);

}
