package org.openmetadata.beans.ddi.lifecycle.physicalinstance.impl;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.InitializingSchemeItemList;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ResolvingSchemeItemListImpl;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.RecordLayoutBean;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.DataFileIdentificationBean;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.GrossFileStructureBean;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.PhysicalInstanceBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractMaintainableBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.CitationBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.CodeValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.CoverageBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ProprietaryInfoBeanImpl;
import org.openmetadata.ddi_3_1.util.URN;
import org.openmetadata.beans.exceptions.FactoryException;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeEvent.Type;
import org.openmetadata.beans.notification.impl.IdentifiableChangeEventImpl;

public class PhysicalInstanceBeanImpl extends AbstractMaintainableBeanImpl
		implements PhysicalInstanceBean {

	protected CitationBeanImpl citation;
	protected CoverageBeanImpl coverage;
	protected ReferenceSetImpl<RecordLayoutBean> recordLayoutRefList;
	protected InitializingSchemeItemList<DataFileIdentificationBean> dataFileIdentificationList;
	protected GrossFileStructureBeanImpl grossFileStructure;
	protected ProprietaryInfoBeanImpl properietaryInfo;
	protected StatisticsBeanImpl statistics;
	protected CodeValueBeanImpl byteOrder;

	public PhysicalInstanceBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);

		citation = new CitationBeanImpl(beanInitializer, factory, this);
		coverage = new CoverageBeanImpl(beanInitializer, factory, this);

		recordLayoutRefList = new ReferenceSetImpl<RecordLayoutBean>(
				RecordLayoutBean.class, beanInitializer, factory, this);

		dataFileIdentificationList = new ResolvingSchemeItemListImpl<DataFileIdentificationBean>(
				urn.toString(), DataFileIdentificationBean.class, beanInitializer, factory, this);

		properietaryInfo = new ProprietaryInfoBeanImpl(beanInitializer, factory, this);
		statistics = new StatisticsBeanImpl(this, beanInitializer, factory, this);
		byteOrder = new CodeValueBeanImpl(factory, this);
	}

	public void initSetRecordLayouts(String[] urns) {
		recordLayoutRefList.initReferenceUrns(urns);
	}

	public void initSetDataFileIdentifiacations(String[] urns) {
		dataFileIdentificationList.initSetIdentifiableUrns(urns);
	}

	@Override
	public CitationBeanImpl getCitation() {
		if (citation == null) {
			citation = new CitationBeanImpl(this.getBeanInitializer(), this.getBeanFactory(), this);
		}
		return citation;
	}

	@Override
	public CoverageBeanImpl getCoverage() {
		if (coverage == null) {
			coverage = new CoverageBeanImpl(this.getBeanInitializer(), this.getBeanFactory(), this);
		}
		return coverage;
	}

	@Override
	public ReferenceSetImpl<RecordLayoutBean> getRecordLayoutList() {
		return this.recordLayoutRefList;
	}
	
	protected void setDataFileIdentificationList(
			InitializingSchemeItemList<DataFileIdentificationBean> dataFileIdentificationList) {
		this.dataFileIdentificationList = dataFileIdentificationList;
	}

	@Override
	public InitializingSchemeItemList<DataFileIdentificationBean> getDataIdentifications() {
		return dataFileIdentificationList;
	}

	@Override
	public boolean isSetGrossFileStructure() {
		return grossFileStructure != null;
	}

	@Override
	public GrossFileStructureBeanImpl getGrossFileStructure() {
		return grossFileStructure;
	}

	@Override
	public void addNewGrossFileStructure() throws FactoryException {
		if (grossFileStructure != null) {
			throw new FactoryException("The object is already created.");
		} else {
			grossFileStructure = (GrossFileStructureBeanImpl) this
					.getBeanFactory().newInstance(GrossFileStructureBean.class,
							this.getPrimaryIdentifier());		
		}
	}

	@Override
	public void unsetGrossFileStructure() {
		this.notifyChange(new IdentifiableChangeEventImpl(Type.DELETE, grossFileStructure));
		this.grossFileStructure = null;
	}

	@Override
	public ProprietaryInfoBeanImpl getProprietaryInfo() {
		if (properietaryInfo == null) {
			properietaryInfo = new ProprietaryInfoBeanImpl(
					this.getBeanInitializer(),
					this.getBeanFactory(), this);
		}
		return properietaryInfo;
	}

	@Override
	public StatisticsBeanImpl getStatistics() {
		if (statistics == null) {
			statistics = new StatisticsBeanImpl(this, this.getBeanInitializer(), this.getBeanFactory(),
					this);
		}
		return statistics;
	}

	@Override
	public CodeValueBeanImpl getByteOrder() {
		if (byteOrder == null) {
			byteOrder = new CodeValueBeanImpl(this.getBeanFactory(), this);
		}
		return byteOrder;
	}

	@Override
	public void doChangeReference(IdentifiableBean current,
			IdentifiableBean another) {
		// TODO Auto-generated method stub
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		// TODO Auto-generated method stub
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.PhysicalInstance;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return PhysicalInstanceBean.class;
	}
}
