package org.openmetadata.beans.ddi.lifecycle.physicalinstance.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.PathBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.notification.ChangeListener;

public class PathBeanImpl extends UnsettableDdiBeanImpl implements PathBean {
	private static boolean IS_PUBLIC_DEFAULT = true;

	Boolean isPublic = null;
	String strVal = null;

	public PathBeanImpl(DdiBeanFactory factory, ChangeListener listener) {
		super(factory, listener);
		isPublic = null;
		strVal = null;
	}

	@Override
	public boolean isPublic() {
		if (this.isPublic != null) {
			return this.isPublic;
		} else {
			return IS_PUBLIC_DEFAULT;
		}
	}

	@Override
	public boolean isSetIsPublic() {
		return isPublic != null;
	}

	@Override
	public void setIsPublic(boolean boo) {
		this.isPublic = boo;
		this.ddiBeanChanged();
	}

	@Override
	public String getStringValue() {
		if (strVal != null) {
			return strVal;
		} else {
			return "";
		}
	}

	@Override
	public void setStringValue(String value) {
		if (CompareUtil.areDifferentValues(strVal, value)) {
			strVal = value;
			this.ddiBeanChanged();
		}
	}

	@Override
	protected boolean internalIsSet() {
		return !StringUtils.isEmpty(strVal);
	}
}
