package org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.impl;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.DdiBeanListImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.DataItemBean;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.RecordLayoutBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.CodeValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.ddi_3_1.util.URN;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;

public class RecordLayoutBeanImpl extends AbstractBaseRecordLayoutBeanImpl implements
		RecordLayoutBean {

	private Boolean isNameOnFirstRow;
	private final CodeValueBeanImpl charSet;
	private int arrayBase;
	private ReferenceBeanImpl<VariableSchemeBean> defaultVariableShemeRef;
	private final DdiBeanListImpl<DataItemBean> dataItems;

	public RecordLayoutBeanImpl(Boolean isNewInstance, URN urn,
			final MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);
		charSet = new CodeValueBeanImpl(this.getBeanFactory(), this);
		arrayBase = 0;
		dataItems = new DdiBeanListImpl<DataItemBean>(
				DataItemBean.class, beanInitializer, factory, this) {
			@Override
			protected DataItemBean createNew() {
				return new DataItemBeanImpl(
						beanInitializer,
						RecordLayoutBeanImpl.this.getBeanFactory(),
						RecordLayoutBeanImpl.this);

			}
		};
		this.defaultVariableShemeRef = new ReferenceBeanImpl<VariableSchemeBean>(
				VariableSchemeBean.class, this.getBeanFactory(), this);

	}

	public void initSetDefaultVariableSchemeUrn(String urn){
		defaultVariableShemeRef.setReferenceUrn(urn);
	}
	
	@Override
	public boolean getIsNameOnFirstRow() {
		if (this.isNameOnFirstRow != null) {
			return this.isNameOnFirstRow;
		} else {
			return false;
		}
	}

	@Override
	public void setIsNameOnFirstRow(boolean value) {
		if (CompareUtil.areDifferentValues(this.isNameOnFirstRow, value)) {
			this.isNameOnFirstRow = value;
			this.change();
		}
	}

	@Override
	public CodeValueBeanImpl getCharacterSet() {
		return charSet;
	}

	@Override
	public int getArrayBase() {
		return arrayBase;
	}

	@Override
	public void setArrayBease(int value) {
		if (this.arrayBase != value) {
			this.arrayBase = value;
			this.change();
		}
	}

	@Override
	public String getDefaultVaraibleSchemeUrn() {
		if (this.defaultVariableShemeRef != null) {
			return this.defaultVariableShemeRef.getUrn();
		} else {
			return "";
		}
	}

	@Override
	public boolean isSetDefaultVariableScheme() {
		return this.defaultVariableShemeRef.isSet();
	}

	@Override
	public void setDefaultVariableScheme(VariableSchemeBean variableScheme)
			 {
		this.defaultVariableShemeRef.setReferenceTo(variableScheme);
	}

	@Override
	public VariableSchemeBean getDefaultVaraibleScheme() {
		try {
			return this.defaultVariableShemeRef.getReferredObject();
		} catch (ResolverException e) {
			return null;
		}
	}

	@Override
	public DdiBeanListImpl<DataItemBean> getDataItems() {
		return dataItems;
	}

	@Override
	public void doChangeReference(IdentifiableBean current,
			IdentifiableBean another) {
		// TODO Auto-generated method stub
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		// TODO Auto-generated method stub
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.RecordLayout;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return RecordLayoutBean.class;
	}
}
