package org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.impl;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.PhysicalRecordSegmentBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractIdentifiableBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.ddi_3_1.util.URN;

public class PhysicalRecordSegmentBeanImpl extends AbstractIdentifiableBeanImpl
		implements PhysicalRecordSegmentBean {

	private static final int DEFAULT_SEGMENT_ORDER = 1;
	private static final boolean DEFAULT_HAS_SEGMENT_KEY = false;

	Integer segmentOrder;
	Boolean hasSegmentKey;

	KeyVariableReferenceBeanImpl keyVariableReference;
	String fileIdentification;

	public PhysicalRecordSegmentBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);
		segmentOrder = null;
		hasSegmentKey = null;
		keyVariableReference = new KeyVariableReferenceBeanImpl(this,
				this.getBeanFactory(), this);
	}

	@Override
	public boolean isSetSegmentOrder() {
		return this.segmentOrder != null;
	}

	@Override
	public void setSegmentOrder(int value) {
		this.segmentOrder = value;
		this.change();
	}

	@Override
	public int getSegmentOrder() {
		if (this.segmentOrder != null) {
			return this.segmentOrder;
		} else {
			return DEFAULT_SEGMENT_ORDER;
		}
	}

	@Override
	public boolean isSetHasSegementKey() {
		return this.hasSegmentKey != null;
	}

	@Override
	public void setHasSegementKey(boolean value) {
		this.hasSegmentKey = value;
		this.change();
	}

	@Override
	public boolean getHasSegmentKey() {
		if (this.hasSegmentKey != null) {
			return this.hasSegmentKey;
		} else {
			return DEFAULT_HAS_SEGMENT_KEY;
		}
	}

	@Override
	public KeyVariableReferenceBeanImpl getKeyVariableReference() {
		return this.keyVariableReference;
	}

	@Override
	public boolean isSetFileNameIdentification() {
		return this.fileIdentification != null
				&& this.fileIdentification.isEmpty() == false;
	}

	@Override
	public void setFileNameIdentification(String value) {
		this.fileIdentification = value;
		this.change();
	}

	@Override
	public String getFileNameIdentification() {
		return this.fileIdentification;
	}

	@Override
	public void doChangeReference(IdentifiableBean current,
			IdentifiableBean another) {
		// TODO Auto-generated method stub
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		// TODO Auto-generated method stub
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.PhysicalRecordSegment;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return PhysicalRecordSegmentBean.class;
	}

}
