package org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableBean;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.KeyVariableReferenceBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.beans.notification.ChangeListener;

public class KeyVariableReferenceBeanImpl extends
		ReferenceBeanImpl<VariableBean> implements KeyVariableReferenceBean {

	private String variableValue;

	public KeyVariableReferenceBeanImpl(IdentifiableBean referrer,
			DdiBeanFactory factory, ChangeListener listener) {
		super(VariableBean.class, factory, listener);
		variableValue = "";
	}

	@Override
	public String getVariableValue() {
		if (this.variableValue != null) {
			return this.variableValue;
		} else {
			return "";
		}
	}
}
