package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.ControlConstructBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.ControlConstructSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.InstructionBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractSchemeItemBean;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.ddi_3_1.util.URN;

public abstract class ControlConstructBeanImpl extends
		AbstractSchemeItemBean<ControlConstructSchemeBean> implements
		ControlConstructBean {

	final private ReferenceSetImpl<InstructionBean> instructionRefSet;

	public ControlConstructBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);
		instructionRefSet = new ReferenceSetImpl<InstructionBean>(
				InstructionBean.class, beanInitializer, factory, this);
	}

	public void initSetInterviewInstructions(String[] interviewInstructionUrns) {
		instructionRefSet.initReferenceUrns(interviewInstructionUrns);
	}

	@Override
	public ReferenceSetImpl<InstructionBean> getInterviewInstructionList() {
		return this.instructionRefSet;
	}

	@Override
	public void doChangeReference(IdentifiableBean current,
			IdentifiableBean another)  {
		if (current instanceof InstructionBean
				&& another instanceof InstructionBean) {
			InstructionBean currentInstruction = (InstructionBean) current;
			if (this.instructionRefSet.contains(currentInstruction)) {
				this.instructionRefSet.remove(currentInstruction);
				InstructionBean anotherInstruction = (InstructionBean) another;
				this.instructionRefSet.add(anotherInstruction);
			}
		}
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		if (toRemove instanceof InstructionBean) {
			InstructionBean currentInstruction = (InstructionBean) toRemove;
			if (this.instructionRefSet.contains(currentInstruction)) {
				this.instructionRefSet.remove(currentInstruction);
			}
		}
	}
}
