package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.ConstructSequenceBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.ControlConstructBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.ddi_3_1.util.URN;

public class ConstructSequenceBeanImpl extends SequenceBeanImpl implements
		ConstructSequenceBean {

	final private ReferenceSetImpl<ControlConstructBean> controlConstructRefSet;

	public ConstructSequenceBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);
		controlConstructRefSet = new ReferenceSetImpl<ControlConstructBean>(
				ControlConstructBean.class, beanInitializer, factory, this);
	}

	@Override
	public ReferenceSetImpl<ControlConstructBean> getControlConstructList() {
		return controlConstructRefSet;
	}

	@Override
	public ControlConstructBean[] getControlConstructs() {
		return controlConstructRefSet.toArray(new ControlConstructBean[0]);
	}

	@Override
	public void doChangeReference(IdentifiableBean current,
			IdentifiableBean another) {
		if (current instanceof ControlConstructBean
				&& another instanceof ControlConstructBean) {
			ControlConstructBean currentCC = (ControlConstructBean) current;
			if (this.controlConstructRefSet.contains(currentCC)) {
				this.controlConstructRefSet.remove(currentCC);
				ControlConstructBean anotherCC = (ControlConstructBean) another;
				this.controlConstructRefSet.add(anotherCC);
			}
		}
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		if (toRemove instanceof ControlConstructBean) {
			ControlConstructBean currentCC = (ControlConstructBean) toRemove;
			if (this.controlConstructRefSet.contains(currentCC)) {
				this.controlConstructRefSet.remove(currentCC);
			}
		}
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.Sequence;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return ConstructSequenceBean.class;
	}
}
