package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import org.openmetadata.beans.ddi.lifecycle.datacollection.CodingBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractIdentifiableBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.ddi_3_1.util.URN;

public class CodingBeanImpl extends AbstractIdentifiableBeanImpl implements CodingBean {

	private final GeneralInstructionBeanImpl generalInstruction;
	private final GenerationInstructionBeanImpl generationInstruction;
	private double standardWeight = 1;

	public CodingBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);
		
		generalInstruction = new GeneralInstructionBeanImpl(beanInitializer, factory, this);
		generationInstruction = new GenerationInstructionBeanImpl(beanInitializer, factory, this);
	}
	
	@Override
	public GeneralInstructionBeanImpl getGeneralInstruction() {
		return generalInstruction;
	}


	@Override
	public GenerationInstructionBeanImpl getGenerationInstruction() {
		return generationInstruction;
	}

	@Override
	public double getStandardWeight() {
		return standardWeight;
	}

	@Override
	public void setStandardWeight(double value) {
		if(this.standardWeight != value){
			this.standardWeight = value;
			this.change();
		}
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.Coding;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return CodingBean.class;
	}

	@Override
	protected void doChangeReference(IdentifiableBean toRemove,
			IdentifiableBean toAdd) {
		// do nothing		
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		// do nothing
	}
}
