package org.openmetadata.beans.ddi.lifecycle.conceptualcomponent;


import org.openmetadata.beans.ddi.lifecycle.reusable.SchemeItemBean;
import org.openmetadata.beans.exceptions.FactoryException;
import org.openmetadata.ddi_3_1.util.DdiClass;

public interface UniverseBean extends SchemeItemBean<UniverseSchemeBean> {
	
	public final static DdiClass ddiClass = DdiClass.Universe;

	boolean getIsInclusive();

	void setIsInclusive(boolean isInclusive);

	boolean isSetIsInclusive();

	UniverseBean getParentUniverse();

	UniverseBean[] getSubUniverses();

	/**
	 * Remove a sub universe recursively
	 * 
	 * @param subUniverse
	 * @return
	 */
	boolean removeSubUniverse(UniverseBean subUniverse);

	UniverseBean addNewSubUniverse() throws FactoryException;

	boolean isSubUniverse();

	boolean canMergeFrom(UniverseBean from);

	void mergeFrom(UniverseBean from) throws 
			FactoryException;
}
