package org.openmetadata.beans.ddi.lifecycle.conceptualcomponent;

import org.openmetadata.beans.ddi.lifecycle.adt.ReferenceSet;
import org.openmetadata.beans.ddi.lifecycle.reusable.SchemeItemBean;
import org.openmetadata.ddi_3_1.util.DdiClass;

public interface ConceptGroupBean extends SchemeItemBean<ConceptSchemeBean> {
	
	public final static DdiClass ddiClass = DdiClass.ConceptGroup;

	ReferenceSet<ConceptGroupBean> getConceptGroupList();

	ReferenceSet<ConceptBean> getConceptList();

	boolean isSetDefiningConcept();

	ConceptBean getDefiningConcept();

	void setDefiningConcept(ConceptBean concept) ;

	String getDefiningConceptUrn();

	/**
	 * Tell whether the grouping is administrative purpose or defining concepts.
	 * 
	 * @return true if the grouping is for defining purpose
	 */
	boolean isDefiningConcepts();

	boolean isAdministrativePurpose();

	void setToAdministrativePurpose();

}
