package org.openmetadata.beans.ddi.lifecycle.archive.impl;

import java.util.ArrayList;
import java.util.List;

import org.openmetadata.beans.ddi.lifecycle.archive.AddressBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.notification.ChangeListener;

public class AddressBeanImpl extends UnsettableDdiBeanImpl implements
		AddressBean {

	private String type;
	private String privacy;

	private List<String> lines;
	private String city;
	private String state;
	private String postal;

	public AddressBeanImpl(DdiBeanFactory factory, ChangeListener listener) {
		super(factory, listener);
		type = null;
		privacy = null;
		lines = new ArrayList<String>();
		city = null;
		state = null;
		postal = null;
	}

	@Override
	public String getType() {
		return StringUtils.defaultString(this.type);
	}

	@Override
	public void setType(String value) {
		this.type = value;
		this.ddiBeanChanged();
	}

	@Override
	public boolean isSetType() {
		return !StringUtils.isEmpty(this.type);
	}

	@Override
	public String getPrivacy() {
		return StringUtils.defaultString(this.privacy);
	}

	@Override
	public void setPrivacy(String value) {
		privacy = value;
		this.ddiBeanChanged();
	}

	@Override
	public boolean isSetPrivacy() {
		return !StringUtils.isEmpty(privacy);
	}
	
	@Override
	public String[] getLines() {
		return this.lines.toArray(new String[0]);
	}

	@Override
	public void setLines(String[] lines) {
		this.lines.clear();
		for (String line : lines) {
			this.lines.add(line);
		}
		this.ddiBeanChanged();
	}

	@Override
	public String getCity() {
		return StringUtils.defaultString(city);
	}

	@Override
	public void setCity(String value) {
		city = value;
		this.ddiBeanChanged();
	}

	@Override
	public boolean isSetCity() {
		return !StringUtils.isEmpty(city);
	}

	@Override
	public String getState() {
		return StringUtils.defaultString(state);
	}

	@Override
	public void setState(String value) {
		state = value;
		this.ddiBeanChanged();
	}

	@Override
	public boolean isSetState() {
		return !StringUtils.isEmpty(state);
	}

	@Override
	public String getPostal() {
		return StringUtils.defaultString(postal);
	}

	@Override
	public void setPostal(String value) {
		postal = value;
		this.ddiBeanChanged();
	}

	@Override
	public boolean isSetPostal() {
		return postal != null;
	}

	@Override
	protected boolean internalIsSet() {
		return (!lines.isEmpty()) ||
				!StringUtils.isEmpty(type) || 
				!StringUtils.isEmpty(privacy) ||
				!StringUtils.isEmpty(city) || 
				!StringUtils.isEmpty(state) ||
				!StringUtils.isEmpty(postal) ;
	}
}
