package org.openmetadata.beans.ddi.lifecycle.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public enum DateDataFormat {
	MONTH_DAY_YEAR2D_SLASH("yyyy", "MM/yyyy", "MM/dd/yy", "MM/dd/yy HH:mm:ss"), DAY_MONTH_YEAR2D_SLASH(
			"yyyy", "MM/yyyy", "dd/MM/yy", "dd/MM/yy HH:mm:ss"), DAY_MONTH_YEAR4D_SLASH(
			"yyyy", "MM/yyyy", "dd/MM/yyyy", "dd/MM/yyyy HH:mm:ss"), YEAR4D_MONTH_DAY_SLASH(
			"yyyy", "yyyy/MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss"), MONTH_DAY_YEAR4D_DASH(
			"yyyy", "MM-yyyy", "MM-dd-yyyy", "MM-dd-yyyy HH:mm:ss");

	private final Map<XmlDateDataType, String> map = new HashMap<XmlDateDataType, String>();

	DateDataFormat(String yearPattern, String monthyearPattern,
			String datePattern, String datetimePattern) {
		map.put(XmlDateDataType.DATE, datePattern);
		map.put(XmlDateDataType.DATETIME, datetimePattern);
		map.put(XmlDateDataType.GYEAR, yearPattern);
		map.put(XmlDateDataType.GYEARMONTH, monthyearPattern);
	}

	public Date parseDate(String formattedStr, XmlDateDataType dateType)
			throws ParseException {
		String pattern = map.get(dateType);
		SimpleDateFormat simDateFormat = new SimpleDateFormat(pattern);
		Date date = simDateFormat.parse(formattedStr);
		return date;
	}

	public boolean validate(String formattedDateStr, XmlDateDataType dateType) {
		// The rationale is parse to date, then serialize and compare if the
		// same, then it is valid.
		try {
			String pattern = map.get(dateType);
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
			Date date = simpleDateFormat.parse(formattedDateStr);
			String reconstructedStr = simpleDateFormat.format(date);
			// System.out.println("formatted : "+ formattedDateStr);
			// System.out.println("reconstructed : "+ reconstructedStr);
			// we need to check because SimpleDate likes to wrap/roll around the
			// dates such as month 13 to 01 the next year
			// also simple date is fine with some extra slash or characters in
			// the end or front
			return formattedDateStr.equals(reconstructedStr);
		} catch (ParseException e) {
			return false;
		}
	}

	public String getFormattedString(XmlDateDataType xmlDateDataType, Date date) {
		String pattern = map.get(xmlDateDataType);
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
		return simpleDateFormat.format(date);
	}
}
