package org.openmetadata.beans.ddi.lifecycle.simpledc.impl;

import java.util.HashMap;
import java.util.Map;

import org.openmetadata.beans.ddi.lifecycle.notification.BeanChangeEvent;
import org.openmetadata.beans.ddi.lifecycle.simpledc.ElementBean;
import org.openmetadata.beans.ddi.lifecycle.simpledc.ElementValueBean;
import org.openmetadata.beans.notification.ChangeEvent.Type;
import org.openmetadata.beans.notification.ChangeListener;

public class ElementValueBeanImpl implements ElementValueBean {

	private ChangeListener changeListener;
	private Map<String, ElementBean> map = new HashMap<String, ElementBean>();

	public ElementValueBeanImpl(ChangeListener changeListener) {
		this.changeListener = changeListener;
	}
	@Override
	public ElementBean getBean(String lang) {
		if (map.containsKey(lang)) {
			return map.get(lang);
		} else {
			map.put(lang, new ElementBeanImpl(lang, ""));
			changeListener.notifyChange(new BeanChangeEvent(Type.CREATE, this));
			return map.get(lang);
		}
	}

}
