package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.DdiBeanListImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.NoteBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.NoteTypeCode;
import org.openmetadata.beans.ddi.lifecycle.reusable.RelationshipBean;
import org.openmetadata.ddi_3_1.util.URN;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.openmetadata.beans.impl.MutableBeanInitializer;

public class NoteBeanImpl extends AbstractIdentifiableBeanImpl implements
		NoteBean {

	private String attr_lang;
	private NoteTypeCode attr_type;

	private CodeValueBeanImpl subject;
	private DdiBeanListImpl<RelationshipBean> relationshipList;
	private String responsibility;
	private InternationalStringValueBeanImpl header;
	private StructuredStringValueBeanImpl content;

	public NoteBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory beanFactory) {
		super(isNewInstance, urn, beanInitializer, beanFactory);
		
		subject = new CodeValueBeanImpl(beanFactory, this);
		responsibility = null;
		header = new InternationalStringValueBeanImpl(this.getBeanFactory(),
				this);
		content = new StructuredStringValueBeanImpl(this.getBeanFactory(), this);

		relationshipList = new DdiBeanListImpl<RelationshipBean>(
				RelationshipBean.class, beanInitializer, beanFactory, this) {
			@Override
			protected RelationshipBean createNew() {
				return new RelationshipBeanImpl(getBeanFactory(), this);
			}
		};
	}

	@Override
	public String getLanguage() {
		return attr_lang;
	}

	@Override
	public void setLanguage(String lang) {
		if (CompareUtil.areDifferentValues(attr_lang, lang)) {
			attr_lang = lang;
			this.change();
		}
	}

	@Override
	public boolean isSetLanguage() {
		return attr_lang != null;
	}

	@Override
	public NoteTypeCode getType() {
		if (attr_type != null) {
			return attr_type;
		} else {
			return NoteTypeCode.SYSTEM;
		}
	}

	@Override
	public void setType(NoteTypeCode value) {
		if (value != attr_type) {
			attr_type = value;
			this.change();
		}
	}

	@Override
	public CodeValueBeanImpl getSubject() {
		return subject;
	}

	@Override
	public DdiBeanListImpl<RelationshipBean> getRelationshipList() {
		return relationshipList;
	}

	@Override
	public String getResponsibility() {
		return responsibility;
	}

	@Override
	public void setResponsibility(String value) {
		if (CompareUtil.areDifferentValues(this.responsibility, value)) {
			this.responsibility = value;
			this.change();
		}
	}

	@Override
	public boolean isSetResponsibility() {
		return responsibility != null;
	}

	@Override
	public InternationalStringValueBeanImpl getHeader() {
		return header;
	}

	@Override
	public StructuredStringValueBeanImpl getContent() {
		return content;
	}

	@Override
	public void doChangeReference(IdentifiableBean toDerefer,
			IdentifiableBean toRefer) {
		// TODO Auto-generated method stub
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		// TODO Auto-generated method stub
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.Note;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return NoteBean.class;
	}

}
