package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.CodeValueBean;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.notification.ChangeListener;

public class CodeValueBeanImpl extends UnsettableDdiBeanImpl implements
		CodeValueBean {

	private String stringValue;
	private String codeListId;
	private String codeListName;
	private String codeListAgency;
	private String codeListVersion;
	private String otherValue;
	private String codeListUrn;
	private String codeListSchemeUrn;

	public CodeValueBeanImpl(DdiBeanFactory factory, ChangeListener listener) {
		super(factory, listener);
	}

	@Override
	public String getStringValue() {
		return StringUtils.defaultString(stringValue);
	}

	@Override
	public void setStringValue(String value) {
		if (CompareUtil.areDifferentValues(stringValue, value)) {
			stringValue = value;
			populate();
			this.ddiBeanChanged();
		}
	}

	@Override
	public String getCodeListID() {
		return StringUtils.defaultString(codeListId);
	}

	@Override
	public void setCodeListID(String codeListID) {
		if (CompareUtil.areDifferentValues(this.codeListId, codeListID)) {
			this.codeListId = codeListID;
			populate();
			this.ddiBeanChanged();
		}
	}

	@Override
	public boolean isSetCodeListID() {
		return codeListId != null;
	}

	@Override
	public String getCodeListName() {
		return StringUtils.defaultString(codeListName);
	}

	@Override
	public void setCodeListName(String codeListName) {
		if (CompareUtil.areDifferentValues(this.codeListName, codeListName)) {
			this.codeListName = codeListName;
			populate();
			this.ddiBeanChanged();
		}
	}

	@Override
	public boolean isSetCodeListName() {
		return codeListName != null;
	}

	@Override
	public String getCodeListAgency() {
		return StringUtils.defaultString(codeListAgency);
	}

	@Override
	public void setCodeListAgency(String codeListAgency) {
		if (CompareUtil.areDifferentValues(this.codeListAgency, codeListAgency)) {
			this.codeListAgency = codeListAgency;
			populate();
			this.ddiBeanChanged();
		}
	}

	@Override
	public boolean isSetCodeListAgency() {
		return codeListAgency != null;
	}

	@Override
	public String getCodeListVersion() {
		return StringUtils.defaultString(codeListVersion);
	}

	@Override
	public void setCodeListVersion(String codeListVersion) {
		if (CompareUtil.areDifferentValues(this.codeListVersion,
				codeListVersion)) {
			this.codeListVersion = codeListVersion;
			populate();
			this.ddiBeanChanged();
		}
	}

	@Override
	public boolean isSetCodeListVersion() {
		return codeListVersion != null;
	}

	@Override
	public String getOtherValue() {
		return StringUtils.defaultString(otherValue);
	}

	@Override
	public void setOtherValue(String value) {
		if (CompareUtil.areDifferentValues(this.otherValue, value)) {
			this.otherValue = value;
			populate();
			this.ddiBeanChanged();
		}
	}

	@Override
	public boolean isSetOtherValue() {
		return otherValue != null;
	}

	@Override
	public String getCodeListUrn() {
		return StringUtils.defaultString(codeListUrn);
	}

	@Override
	public void setCodeListUrn(String codeListUrn) {
		if (CompareUtil.areDifferentValues(this.codeListUrn, codeListUrn)) {
			this.codeListUrn = codeListUrn;
			populate();
			this.ddiBeanChanged();
		}
	}

	@Override
	public boolean isSetCodeListUrn() {
		return codeListUrn != null;
	}

	@Override
	public String getCodeListSchemeUrn() {
		return StringUtils.defaultString(codeListSchemeUrn);
	}

	@Override
	public void setCodeListSchemeUrn(String codeListSchemeUrn) {
		if (CompareUtil.areDifferentValues(this.codeListSchemeUrn,
				codeListSchemeUrn)) {
			this.codeListSchemeUrn = codeListSchemeUrn;
			populate();
			this.ddiBeanChanged();
		}
	}

	@Override
	public boolean isSetCodeListSchemeUrn() {
		return codeListSchemeUrn != null;
	}
	
	@Override
	protected boolean internalIsSet() {
		return !StringUtils.isEmpty(stringValue);
	}

}
