package org.openmetadata.beans.ddi.lifecycle.notification;

import org.openmetadata.beans.ddi.lifecycle.reusable.DdiBean;
import org.openmetadata.beans.notification.ChangeEvent;

public class BeanChangeEvent implements ChangeEvent {

	final private DdiBean ddiBean;
	final private ChangeEvent initiatingEvent;
	final private Type type;

	public BeanChangeEvent(Type type, DdiBean ddiBean,
			ChangeEvent initiatingEvent) {
		this.ddiBean = ddiBean;
		this.initiatingEvent = initiatingEvent;
		this.type = Type.UPDATE;
	}

	public BeanChangeEvent(Type type, DdiBean ddiBean) {
		this.ddiBean = ddiBean;
		this.initiatingEvent = null;
		this.type = type;
	}

	public DdiBean getBean() {
		return ddiBean;
	}

	public boolean hasInitiatingEvent() {
		return initiatingEvent != null;
	}

	/*
	 * public ChangeEvent getInitiatingEvent(){ return initiatingEvent; }
	 */

	@Override
	public Type getType() {
		return type;
	}

	@Override
	public ChangeEvent[] getInitiatingEvents() {
		if (this.hasInitiatingEvent()) {
			ChangeEvent[] events = new ChangeEvent[1];
			events[0] = this.initiatingEvent;
			return events;
		} else {
			return new ChangeEvent[0];
		}
	}
}
