package org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl;

import java.util.ArrayList;
import java.util.List;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.InitializingSchemeItemList;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ResolvingSchemeItemListImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CategoryBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CategorySchemeBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CodeSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractMaintainableBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.ddi_3_1.util.URN;

public class CategorySchemeBeanImpl extends AbstractMaintainableBeanImpl
		implements CategorySchemeBean {

	private InitializingSchemeItemList<CategoryBean> categoryList;

	public CategorySchemeBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);
		categoryList = new ResolvingSchemeItemListImpl<CategoryBean>(this.getUrn(),
				CategoryBean.class, beanInitializer, factory, this);
	}

	public void initSetCategories(String[] urns) {
		categoryList.initSetIdentifiableUrns(urns);
	}

	protected void setCategoryList(
			InitializingSchemeItemList<CategoryBean> categoryList) {
		this.categoryList = categoryList;
	}
	
	@Override
	public InitializingSchemeItemList<CategoryBean> getCategoryList() {
		return categoryList;
	}

	@Override
	public CodeSchemeBean[] getReferringCodeSchemes() {
		List<CodeSchemeBean> codeSchemeList = new ArrayList<CodeSchemeBean>();
		for (IdentifiableBean idBean : this.getReferrers()) {
			if (idBean instanceof CodeSchemeBean) {
				codeSchemeList.add((CodeSchemeBean) idBean);
			}
		}
		return codeSchemeList.toArray(new CodeSchemeBean[0]);
	}

	@Override
	public void doChangeReference(IdentifiableBean current,
			IdentifiableBean another) {
		// TODO Auto-generated method stub
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		// TODO Auto-generated method stub
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.CategoryScheme;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return CategorySchemeBean.class;
	}
}
