package org.openmetadata.beans.ddi.lifecycle.logicalproduct;

import org.openmetadata.beans.ddi.lifecycle.adt.DdiBeanList;
import org.openmetadata.beans.ddi.lifecycle.adt.SchemeItemList;
import org.openmetadata.beans.ddi.lifecycle.adt.ReferenceSet;
import org.openmetadata.beans.ddi.lifecycle.reusable.CoverageBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.MaintainableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.NoteBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.OtherMaterialBean;
import org.openmetadata.ddi_3_1.util.DdiClass;

public interface LogicalProductBean extends MaintainableBean {
	
	public final static DdiClass ddiClass = DdiClass.LogicalProduct;

	CoverageBean getCoverage();

	SchemeItemList<DataRelationshipBean> getDataRelationshipList();

	DdiBeanList<OtherMaterialBean> getOtherMaterialList();

	DdiBeanList<NoteBean> getNoteList();

	ReferenceSet<CategorySchemeBean> getCategorySchemeList();

	ReferenceSet<CodeSchemeBean> getCodeSchemeList();

	ReferenceSet<VariableSchemeBean> getVariableSchemeList();
}
