package org.openmetadata.beans.ddi.lifecycle.adt.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.openmetadata.beans.ddi.lifecycle.adt.KeyedBean;
import org.openmetadata.beans.ddi.lifecycle.adt.KeyedValueBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.notification.ChangeListener;

public abstract class KeyedValueBeanImpl<B extends KeyedBean> extends UnsettableDdiBeanImpl implements KeyedValueBean<B>{
	
	private final Class<B> beanClass;
	private Map<Map<Enum<?>, Object>, B> map;
	
	protected abstract B createNewBean(Map<Enum<?>, Object> keyMap);
	
	protected KeyedValueBeanImpl(Class<B> beanClass, DdiBeanFactory beanFactory,
			ChangeListener changeListener) {
		super(beanFactory, changeListener);
	
		map = new LinkedHashMap<Map<Enum<?>, Object>, B>();
		// map = Collections.synchronizedMap(new LinkedHashMap<Map<Enum<?>, Object>, B>());		
		this.beanClass = beanClass;
	}
	
	@Override
	public B getBean(Map<Enum<?>, Object> keys){
		if(map.containsKey(keys)){
			return map.get(keys);
		}else{
			B newBean = this.createNewBean(keys);
			map.put(keys, newBean);
			return newBean;
		}
	}	
	
	@SuppressWarnings("unchecked")
	@Override
	public B[] findBeans(Map<Enum<?>, Object> query) {
		List<B> tmpList = new ArrayList<B>();
		for(Map<Enum<?>, Object> myKeys : map.keySet()){
			if(myKeys.entrySet().containsAll(query.entrySet())){
				B bean = map.get(myKeys);
				tmpList.add(bean);
			}
		}	
		return tmpList.toArray((B[])Array.newInstance(beanClass, 0));	
	}
	
	@Override
	public void remove(Map<Enum<?>, Object> keys) {
		map.remove(keys);
		this.ddiBeanChanged();
	}
	
	@Override
	public void removeAll(Map<Enum<?>, Object> query) {
		// TODO implement removing objects using query
		Set<Map<Enum<?>, Object>> keysMapToRemove = new HashSet<Map<Enum<?>, Object>>();
		
		for(Map<Enum<?>, Object> myKeys : map.keySet()){
			if(myKeys.entrySet().containsAll(query.entrySet())){
				keysMapToRemove.add(myKeys);
			}
		}		
		for(Map<Enum<?>, Object> keys : keysMapToRemove){
			map.remove(keys);
		}
		this.ddiBeanChanged();
	}

	@Override
	public int size() {
		return map.size();
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public B[] getAllValues() {
		return map.values().toArray((B[])Array.newInstance(beanClass, 0));
	}
	
	@Override
	protected final boolean internalIsSet() {
		return !map.isEmpty();
	}
}