/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.BaseDateBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.DateBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.DateRangeBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.BaseDateBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.DateRangeBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;

public class DateBeanImpl
extends UnsettableDdiBeanImpl
implements DateBean {
    private String calendarStr;
    private BaseDateBeanImpl simpleDateBean;
    private DateRangeBeanImpl dateRangeBean;
    private boolean isRange = false;

    public DateBeanImpl(MutableBeanInitializer beanInitializer, DdiBeanFactory factory, ChangeListener listener) {
        super(factory, listener);
        this.simpleDateBean = new BaseDateBeanImpl(factory, this);
        this.dateRangeBean = new DateRangeBeanImpl(beanInitializer, factory, this);
        this.isRange = false;
    }

    @Override
    public boolean isSetCalendar() {
        return this.calendarStr != null && !this.calendarStr.isEmpty();
    }

    @Override
    public String getCalendar() {
        return StringUtils.defaultString((String)this.calendarStr);
    }

    @Override
    public void setCaleander(String calendar) {
        if (CompareUtil.areDifferentValues(this.calendarStr, calendar)) {
            this.calendarStr = calendar;
            this.populate();
            this.ddiBeanChanged();
        }
    }

    @Override
    public BaseDateBean getSimpleDate() {
        return this.simpleDateBean;
    }

    @Override
    public DateRangeBean getDateRange() {
        return this.dateRangeBean;
    }

    @Override
    public void setIsRange(boolean isRange) {
        this.isRange = isRange;
        this.ddiBeanChanged();
    }

    @Override
    public boolean isRange() {
        return this.isRange;
    }

    @Override
    public boolean internalIsSet() {
        return this.simpleDateBean.isSet() || this.dateRangeBean.isSet();
    }
}

