/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableSpecificationReferenceSet;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl.VariableSpecificationReferenceBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.ddi.util.exceptions.URNFormatException;

public class VariableSpecificationReferenceSetImpl
extends UnsettableDdiBeanImpl
implements VariableSpecificationReferenceSet {
    private Map<String, VariableSpecificationReferenceBeanImpl> map = new HashMap<String, VariableSpecificationReferenceBeanImpl>();

    public VariableSpecificationReferenceSetImpl(DdiBeanFactory factory, ChangeListener listener) {
        super(factory, listener);
    }

    public void initSetVariableUrns(String[] variableUrns) throws URNFormatException {
        String[] stringArray = variableUrns;
        int n = variableUrns.length;
        int n2 = 0;
        while (n2 < n) {
            String variableUrn = stringArray[n2];
            VariableSpecificationReferenceBeanImpl varSpecRef = new VariableSpecificationReferenceBeanImpl(this.getBeanFactory(), this);
            varSpecRef.initSetVariableUrn(variableUrn);
            this.map.put(variableUrn, varSpecRef);
            ++n2;
        }
    }

    @Override
    public Iterator<VariableBean> iterator() {
        ArrayList<VariableBean> varList = new ArrayList<VariableBean>();
        for (VariableSpecificationReferenceBeanImpl varSpecRef : this.map.values()) {
            VariableBean variable = varSpecRef.getVariable();
            varList.add(variable);
        }
        return varList.iterator();
    }

    @Override
    public boolean contains(VariableBean bean) {
        if (bean != null) {
            return this.map.containsKey(bean.getUrn());
        }
        return false;
    }

    @Override
    public boolean contains(String urn) {
        if (urn != null) {
            return this.map.containsKey(urn);
        }
        return false;
    }

    @Override
    public boolean add(VariableBean bean) {
        if (!this.contains(bean) && bean != null) {
            VariableSpecificationReferenceBeanImpl varSpecRef = new VariableSpecificationReferenceBeanImpl(this.getBeanFactory(), this);
            try {
                varSpecRef.initSetVariableUrn(bean.getUrn());
                this.map.put(bean.getUrn(), varSpecRef);
                return true;
            }
            catch (URNFormatException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean remove(VariableBean bean) {
        if (bean != null && this.map.containsKey(bean.getUrn())) {
            this.map.remove(bean.getUrn());
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(String urn) {
        if (urn != null && this.map.containsKey(urn)) {
            this.map.remove(urn);
            return true;
        }
        return false;
    }

    public VariableBean[] toArray(VariableBean[] arr) {
        ArrayList<VariableBean> varList = new ArrayList<VariableBean>();
        for (VariableSpecificationReferenceBeanImpl varSpecRef : this.map.values()) {
            VariableBean variable = varSpecRef.getVariable();
            varList.add(variable);
        }
        return varList.toArray(arr);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public String[] getUrns() {
        return this.map.keySet().toArray(new String[0]);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    protected boolean internalIsSet() {
        return !this.map.isEmpty();
    }

    @Override
    public void moveBefore(VariableBean move, VariableBean before) {
        LinkedHashMap<String, VariableSpecificationReferenceBeanImpl> tmpMap = new LinkedHashMap<String, VariableSpecificationReferenceBeanImpl>();
        tmpMap.putAll(this.map);
        this.map.clear();
        for (String urn : tmpMap.keySet()) {
            if (urn.equals(move.getUrn())) continue;
            if (urn.equals(before.getUrn())) {
                this.map.put(move.getUrn(), (VariableSpecificationReferenceBeanImpl)tmpMap.get(move.getUrn()));
            }
            this.map.put(urn, (VariableSpecificationReferenceBeanImpl)tmpMap.get(urn));
        }
        this.ddiBeanChanged();
    }

    @Override
    public void moveAfter(VariableBean move, VariableBean after) {
        LinkedHashMap<String, VariableSpecificationReferenceBeanImpl> tmpMap = new LinkedHashMap<String, VariableSpecificationReferenceBeanImpl>();
        tmpMap.putAll(this.map);
        this.map.clear();
        for (String urn : tmpMap.keySet()) {
            if (urn.equals(move.getUrn())) continue;
            this.map.put(urn, (VariableSpecificationReferenceBeanImpl)tmpMap.get(urn));
            if (!urn.equals(after.getUrn())) continue;
            this.map.put(move.getUrn(), (VariableSpecificationReferenceBeanImpl)tmpMap.get(move.getUrn()));
        }
        this.ddiBeanChanged();
    }
}

