/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.factory;

import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanImplementationConstructor;
import org.openmetadata.beans.exceptions.FactoryException;
import org.openmetadata.beans.factory.impl.BeanFactoryImpl;
import org.openmetadata.beans.impl.BeanInitializer;
import org.openmetadata.beans.impl.IdentifiableBeanImpl;
import org.openmetadata.beans.notification.ChangeEvent;
import org.openmetadata.beans.notification.IdentifiableChangeEvent;
import org.openmetadata.beans.notification.impl.ConsolidatedEvent;
import org.openmetadata.beans.notification.impl.CreationEvent;

public class DdiBeanFactory
extends BeanFactoryImpl {
    private DdiBeanImplementationConstructor implementationConstructor;

    public void setDdiBeanImplementationConstructor(DdiBeanImplementationConstructor implementationConstructor) {
        if (this.implementationConstructor != null && !this.implementationConstructor.equals(implementationConstructor)) {
            String msg = "Implementation constructor cannot be reset.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        this.implementationConstructor = implementationConstructor;
        this.setImplementationConstructor(implementationConstructor);
    }

    protected final DdiBeanImplementationConstructor getDdiBeanImplementationConstructor() {
        if (this.implementationConstructor == null) {
            String msg = "ImplementationConstructor has not been set.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        return this.implementationConstructor;
    }

    public <B extends IdentifiableBean> B newInstance(Class<B> beanClass, String parentUrn) throws FactoryException {
        this.setCollectChangeEvents(true);
        DdiBeanImplementationConstructor implConstructor = this.getDdiBeanImplementationConstructor();
        IdentifiableBeanImpl bean = implConstructor.constructImplementation(beanClass, parentUrn);
        if (!bean.verifyInitializer((BeanInitializer)this)) {
            throw new RuntimeException("Bean was not constructed properly: initializer has not been set as expected.");
        }
        this.setCollectChangeEvents(false);
        ConsolidatedEvent beanEvent = this.getConsolidatedEvent((IdentifiableBean)bean);
        if (!beanEvent.getType().equals((Object)ChangeEvent.Type.CREATE)) {
            beanEvent.addEvent((IdentifiableChangeEvent)new CreationEvent((IdentifiableBean)bean));
        }
        this.notifyChangeEvent((IdentifiableChangeEvent)beanEvent);
        for (ConsolidatedEvent event : this.getConsolidatedEvents()) {
            this.notifyChangeEvent((IdentifiableChangeEvent)event);
        }
        return (B)this.castBean(beanClass, (IdentifiableBean)bean);
    }
}

