/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.adt.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.openmetadata.beans.ddi.lifecycle.adt.DdiBeanList;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.DdiBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.DdiBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;

public abstract class DdiBeanListImpl<B extends DdiBean>
extends DdiBeanImpl
implements DdiBeanList<B> {
    private final List<B> list = new ArrayList<B>();
    private final Class<B> beanClass;

    protected abstract B createNew();

    public DdiBeanListImpl(Class<B> beanClass, MutableBeanInitializer beanInitializer, DdiBeanFactory factory, ChangeListener beanChangeListener) {
        super(beanInitializer, factory, beanChangeListener);
        this.beanClass = beanClass;
    }

    protected List<B> getInternalList() {
        return this.list;
    }

    @Override
    public final B addNew() {
        B bean = this.createNew();
        if (bean != null) {
            this.add(bean);
        }
        this.ddiBeanChanged();
        return bean;
    }

    protected boolean add(B bean) {
        boolean returnedVal = this.list.add(bean);
        if (returnedVal) {
            this.ddiBeanChanged();
        }
        return returnedVal;
    }

    @Override
    public boolean contains(B bean) {
        return this.list.contains(bean);
    }

    @Override
    public Iterator<B> iterator() {
        return this.list.iterator();
    }

    @Override
    public boolean remove(B bean) {
        boolean isRemoved = this.list.remove(bean);
        if (isRemoved) {
            this.ddiBeanChanged();
        }
        return isRemoved;
    }

    @Override
    public void moveBefore(B move, B before) {
        if (move == before) {
            return;
        }
        if (this.list.contains(move) && this.list.contains(before)) {
            this.list.remove(move);
            int beforeIndex = this.list.lastIndexOf(before);
            this.list.add(beforeIndex, move);
            this.ddiBeanChanged();
        }
    }

    @Override
    public void moveAfter(B move, B after) {
        if (move == after) {
            return;
        }
        if (this.list.contains(move) && this.list.contains(after)) {
            this.list.remove(move);
            int afterIndex = this.list.lastIndexOf(after);
            if (afterIndex < this.list.size() - 1) {
                this.list.add(afterIndex + 1, move);
            } else {
                this.list.add(move);
            }
            this.ddiBeanChanged();
        }
    }

    @Override
    public B[] toArray() {
        DdiBean[] typeArr = (DdiBean[])Array.newInstance(this.beanClass, 0);
        return this.list.toArray(typeArr);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public void sort(Comparator<B> comparator) {
        Collections.sort(this.list, comparator);
        this.ddiBeanChanged();
    }
}

