package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import java.util.HashMap;
import java.util.Map;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.UserIDBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.UserIDValueBean;
import org.openmetadata.beans.notification.ChangeListener;

public class UserIDValueBeanImpl extends UnsettableDdiBeanImpl implements
		UserIDValueBean {

	private Map<String, UserIDBean> map;

	public UserIDValueBeanImpl(DdiBeanFactory beanFactory,
			ChangeListener changeListener) {
		super(beanFactory, changeListener);

		map = new HashMap<String, UserIDBean>();
	}

	@Override
	public UserIDBean getBean(String type) {
		if (map.keySet().contains(type) == false) {
			UserIDBean uidBean = new UserIDBeanImpl(type,
					this.getBeanFactory(), this);
			map.put(type, uidBean);
		}
		return map.get(type);
	}

	@Override
	public UserIDBean[] getAllValues() {
		return map.values().toArray(new UserIDBean[0]);
	}

	@Override
	protected boolean internalIsSet() {
		return map.isEmpty()==false;
	}
}