package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.openmetadata.beans.ddi.lifecycle.adt.DdiBeanList;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.DdiBeanListImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.InternationalCodeValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.TopicalCoverageBean;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;

public class TopicalCoverageBeanImpl extends UnsettableDdiBeanImpl implements
		TopicalCoverageBean {

	private DdiBeanListImpl<InternationalCodeValueBean> subjectList;
	private DdiBeanListImpl<InternationalCodeValueBean> keywordList;

	public TopicalCoverageBeanImpl(
			final MutableBeanInitializer beanInitializer,
			final DdiBeanFactory beanFactory, ChangeListener listener) {
		super(beanFactory, listener);
		subjectList = new DdiBeanListImpl<InternationalCodeValueBean>(
				InternationalCodeValueBean.class, beanInitializer, beanFactory,
				listener) {
			@Override
			protected InternationalCodeValueBean createNew() {
				return new InternationalCodeValueBeanImpl(beanFactory,
						TopicalCoverageBeanImpl.this);
			}
		};
		keywordList = new DdiBeanListImpl<InternationalCodeValueBean>(
				InternationalCodeValueBean.class, beanInitializer, beanFactory,
				listener) {
			@Override
			protected InternationalCodeValueBean createNew() {
				return new InternationalCodeValueBeanImpl(beanFactory,
						TopicalCoverageBeanImpl.this);
			}
		};
	}

	@Override
	public DdiBeanList<InternationalCodeValueBean> getSubjectList() {
		return subjectList;
	}
	
	@Override
	public DdiBeanList<InternationalCodeValueBean> getKeywordList() {
		return keywordList;
	}

	@Override
	protected boolean internalIsSet() {
		return subjectList.size() > 0 || keywordList.size() > 0;
	}
}
