package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.CitationBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.InternationalStringValueBean;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;

public class CitationBeanImpl extends UnsettableDdiBeanImpl implements
		CitationBean {

	private InternationalStringValueBeanImpl title;
	private InternationalStringValueBeanImpl subtitle;
	private InternationalStringValueBeanImpl alterTitle;
	private InternationalStringValueBeanImpl copyright;

	private InternationalStringValueBeanImpl publisher;
	private CreatorValueBeanImpl creators;
	private ContributorValueBeanImpl contributors;
	private DateBeanImpl pubDateBean;
	private List<String> languageList;
	
	private final MutableBeanInitializer beanInitializer;

	public CitationBeanImpl(MutableBeanInitializer beanInitializer, DdiBeanFactory factory, ChangeListener listener) {
		super(factory, listener);
		this.beanInitializer = beanInitializer;

		title = new InternationalStringValueBeanImpl(factory, this);
		subtitle = new InternationalStringValueBeanImpl(factory, this);
		alterTitle = new InternationalStringValueBeanImpl(factory, this);
		copyright = new InternationalStringValueBeanImpl(factory, this);

		publisher = new InternationalStringValueBeanImpl(factory, this);
		creators = new CreatorValueBeanImpl(factory, this);
		contributors = new ContributorValueBeanImpl(factory, this);

		pubDateBean = new DateBeanImpl(beanInitializer, factory, this);
		languageList = new ArrayList<String>();
	}

	@Override
	protected boolean internalIsSet() {
		return title.isSet() || subtitle.isSet() || alterTitle.isSet();
	}

	@Override
	public DateBeanImpl getPublicationDate() {
		if (pubDateBean == null) {
			pubDateBean = new DateBeanImpl(beanInitializer, this.getBeanFactory(), this);
		}
		return pubDateBean;
	}

	@Override
	public String[] getLanguages() {
		return languageList.toArray(new String[0]);
	}

	@Override
	public void setLanguages(String[] languages) {
		this.languageList.clear();
		this.languageList.addAll(Arrays.asList(languages));
		this.ddiBeanChanged();
	}

	@Override
	public boolean isSetLanguage() {
		return this.languageList != null && this.languageList.size() > 0;
	}

	@Override
	public InternationalStringValueBeanImpl getTitle() {
		return title;
	}

	@Override
	public InternationalStringValueBeanImpl getSubTitle() {
		return subtitle;
	}

	@Override
	public InternationalStringValueBeanImpl getAlternateTitle() {
		return alterTitle;
	}

	@Override
	public InternationalStringValueBeanImpl getCopyright() {
		return copyright;
	}
	
	@Override
	public InternationalStringValueBean getPublisher() {
		return publisher;
	}

	@Override
	public CreatorValueBeanImpl getCreators() {
		return creators;
	}

	@Override
	public ContributorValueBeanImpl getContributors() {
		return contributors;
	}
}
