package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.MaintainableBean;
import org.openmetadata.ddi_3_1.util.URN;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.IdentifiableChangeEvent;
import org.openmetadata.beans.notification.ChangeEvent.Type;
import org.openmetadata.beans.notification.impl.IdentifiableChangeEventImpl;

public abstract class AbstractMaintainableBeanImpl extends
		AbstractVersionableBeanImpl implements MaintainableBean {

	public static boolean IS_PUBLISHED_DEFAULT = false;

	private String agency;
	private String externalReferenceDefaultUri;
	private Boolean isPublished;
	private String lang;

	public AbstractMaintainableBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory beanFactory) {
		super(isNewInstance, urn, beanInitializer, beanFactory);

		agency = urn.getAgency();		
	}

	@Override
	public String getAgency() {
		return agency;
	}

	@Override
	public boolean isSetAgency() {
		return agency != null;
	}

	protected void setAgency(String arg0) {
		agency = arg0;
	}

	@Override
	public String getExternalReferenceDefaultURI() {
		return StringUtils.defaultString(externalReferenceDefaultUri);
	}

	@Override
	public boolean isSetExternalReferenceDefaultURI() {
		return !StringUtils.isEmpty(externalReferenceDefaultUri);
	}

	@Override
	public void setExternalReferenceDefaultURI(String value) {
		if (CompareUtil.areDifferentValues(this.externalReferenceDefaultUri,
				value)) {
			externalReferenceDefaultUri = value;
			change();
		}
	}

	@Override
	public boolean getIsPublished() {
		if (isPublished != null) {
			return isPublished;
		} else {
			return IS_PUBLISHED_DEFAULT;
		}
	}

	@Override
	public boolean isSetIsPublished() {
		return isPublished != null;
	}

	@Override
	public void setIsPublished(boolean arg0) {
		if(isPublished == null || isPublished != arg0){
			isPublished = arg0;
			change();
		}		
	}

	@Override
	public String getLang() {
		return StringUtils.defaultString(lang);
	}

	@Override
	public boolean isSetLang() {
		return lang != null;
	}

	@Override
	public void setLang(String value) {
		if (CompareUtil.areDifferentValues(lang, value)) {
			lang = value;
			change();
		}
	}

	@Override
	public void delete() {
		for(IdentifiableBean idBean : this.getReferrers()){
			idBean.changeReference(this, null);
			//idBean.removeReference(this);
		}		
		this.notifyDelete();		
	}
}
