package org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl;

import java.util.HashSet;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.ResolvingSet;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CategoryBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CodeBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CodeList;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CodeSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.ActionCode;
import org.openmetadata.beans.ddi.lifecycle.reusable.AttributeSet;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.LabelValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.NameValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.StructuredStringValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.UserIDValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AttributeSetImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.DdiBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UserIDValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;

public class CodeBeanImpl extends DdiBeanImpl implements CodeBean {
	private static boolean IS_DISCRETE_DEFAULT = true;
	private static boolean IS_TOTAL_DEFAULT = false;

	private final String id;
	private final String value;
	
	private final AttributeSet attrSet;

	private final ReferenceBeanImpl<CategoryBean> categoryReference;
	private final CodeSchemeBean parentScheme;
	private final CodeListImpl codeList;

	private Boolean isDiscrete;
	private Integer levelNumber;
	private Boolean isComprehensive;
	private Boolean isTotal;

	private UserIDValueBeanImpl userIDValues;

	public CodeBeanImpl(String codeVal, CodeSchemeBean parentScheme,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory, ChangeListener changeListener) {
		super(beanInitializer, factory, changeListener);
		value = codeVal;
		id = codeVal;
		userIDValues = new UserIDValueBeanImpl(factory, this);
		
		this.attrSet = new AttributeSetImpl();

		this.parentScheme = parentScheme;
		categoryReference = new ReferenceBeanImpl<CategoryBean>(
				CategoryBean.class, factory, this);
		
		codeList = new CodeListImpl(parentScheme, beanInitializer, factory, this);
	}
	
	public void internalAddCode(CodeBean code) {
		codeList.internalAddCode(code);
	}
	
	@Override
	public AttributeSet getAttributeSet() {
		return attrSet;
	}
	
	public CodeSchemeBean getParentScheme(){
		return parentScheme;
	}
	
	@Override
	public CodeList<? extends CodeBean> getCodeList() {
		return codeList;
	}

	@Override
	public IdentifiableBean[] getReferrers() {
		return new IdentifiableBean[0];
	}
	
	@Override
	public ResolvingSet<IdentifiableBean> getReferrerSet() {
		return new ResolvingSet<IdentifiableBean>(
				new HashSet<String>(), IdentifiableBean.class, 
				this.getBeanFactory());
	}

	/*private static boolean isAlphaNumeric(String str) {
		return str.matches("[a-zA-z0-9]*");
	}*/

	@Override
	public boolean getIsDiscrete() {
		if (isSetIsDiscrete()) {
			return isDiscrete;
		} else {
			return IS_DISCRETE_DEFAULT;
		}
	}

	@Override
	public void setIsDiscrete(boolean isDiscrete) {
		if (CompareUtil.areDifferentValues(this.isDiscrete, isDiscrete)) {
			this.isDiscrete = isDiscrete;
			this.ddiBeanChanged();
		}
	}

	@Override
	public boolean isSetIsDiscrete() {
		return isDiscrete != null;
	}

	@Override
	public int getLevelNumber() {
		if (isSetLevelNumber()) {
			return levelNumber;
		} else {
			return 0;
		}
	}

	@Override
	public void setLevelNumber(int value) {
		if (CompareUtil.areDifferentValues(this.levelNumber, value)) {
			this.levelNumber = value;
			this.ddiBeanChanged();
		}
	}

	@Override
	public boolean isSetLevelNumber() {
		return levelNumber != null;
	}

	@Override
	public boolean getIsComprehensive() {
		return false;
	}

	@Override
	public void setIsComprehensive(boolean value) {
		if (this.isComprehensive == null || this.isComprehensive != value) {
			this.isComprehensive = value;
			this.ddiBeanChanged();
		}
	}

	@Override
	public boolean isSetIsComprehensive() {
		return isComprehensive != null;
	}

	@Override
	public boolean getIsTotal() {
		if (isSetIsTotal()) {
			return isTotal;
		} else {
			return IS_TOTAL_DEFAULT;
		}
	}

	@Override
	public void setIsTotal(boolean boo) {
		if (CompareUtil.areDifferentValues(this.isTotal, boo)) {
			this.isTotal = boo;
			this.ddiBeanChanged();
		}
	}

	@Override
	public boolean isSetIsTotal() {
		return isTotal != null;
	}

	public ReferenceBeanImpl<CategoryBean> getCategoryReference() {
		return categoryReference;
	}

	@Override
	public boolean isSetCategory() {
		return categoryReference.isSet();
	}

	@Override
	public void setCategory(CategoryBean category)  {
		categoryReference.setReferenceTo(category);
	}

	@Override
	public void unsetCategory() {
		categoryReference.unset();
	}

	@Override
	public CategoryBean getCategory() {
		try {
			return categoryReference.getReferredObject();
		} catch (ResolverException e) {
			return null;
		}
	}

	@Override
	public String getCategoryUrn() {
		return categoryReference.getUrn();
	}

	@Override
	public String getValue() {
		return value;
	}

	@Override
	public String getId() {
		return this.id;
	}

	@Override
	public boolean isSetUrn() {
		return true;
	}

	@Override
	public String getUrn() {
		return this.parentScheme.getUrn() + ":" + this.getObjectSource() + "."
				+ this.getId() + "." + "1.0.0";
	}

	@Override
	public boolean isSetObjectSource() {
		return false;
	}

	@Override
	public String getObjectSource() {
		return DdiClass.Code.toString();
	}

	@Override
	public void setObjectSource(String value) {
		// do nothing
	}

	@Override
	public boolean isSetAction() {
		return false;
	}

	@Override
	public ActionCode getAction() {
		return null;
	}

	@Override
	public void setAction(ActionCode arg0) {
		// do nothing
	}

	@Override
	public void changeReference(IdentifiableBean current,
			IdentifiableBean another)  {

		if (current != null && current != another) {
			if (current instanceof CategoryBean) {
				CategoryBean currCtg = (CategoryBean) current;
				if (this.getCategory() == currCtg) {
					if (another != null && another instanceof CategoryBean) {
						CategoryBean anotherCategory = (CategoryBean) another;
						this.categoryReference.setReferenceTo(anotherCategory);
					} else {
						this.categoryReference.unset();
					}
				}
			}
		}
	}

	@Override
	public void removeReference(IdentifiableBean toRemove) {
		if (toRemove != null) {
			if (toRemove instanceof CategoryBean) {
				CategoryBean currCtg = (CategoryBean) toRemove;
				if (this.getCategory() == currCtg) {
					this.categoryReference.unset();
				}
			}
		}
	}

	@Override
	public void copyNameLabelDescription(IdentifiableBean from) {
		// do nothing
	}

	@Override
	public UserIDValueBean getUserIDValues() {
		return this.userIDValues;
	}

	@Override
	public NameValueBean getName() {
		return null;
	}

	@Override
	public LabelValueBean getLabel() {
		return null;
	}

	@Override
	public StructuredStringValueBean getDescription() {
		return null;
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.Code;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return CodeBean.class;
	}

	@Override
	public void removeAllReferences() {
		// TODO Auto-generated method stub
	}

	@Override
	public String getPrimaryIdentifier() {
		return this.getUrn();
	}

	@Override
	public String getContainerIdentifier() {
		return this.parentScheme.getUrn();
	}

}
