package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.archive.OrganizationBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.OperationBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.StructuredStringValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;

public class OperationBeanImpl extends UnsettableDdiBeanImpl implements
		OperationBean {

	private StructuredStringValueBeanImpl description;
	private ReferenceSetImpl<OrganizationBean> orgRefList;

	public OperationBeanImpl(IdentifiableBean referrer,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory, ChangeListener listener) {
		super(factory, listener);

		description = new StructuredStringValueBeanImpl(factory, this);
		orgRefList = new ReferenceSetImpl<OrganizationBean>(
				OrganizationBean.class, beanInitializer, factory, this);
	}

	public void initSetOrganizations(String[] urns) {
		orgRefList.initReferenceUrns(urns);
	}

	@Override
	public StructuredStringValueBeanImpl getDescription() {
		return description;
	}

	@Override
	public ReferenceSetImpl<OrganizationBean> getAgencyOrganizationList() {
		return orgRefList;
	}

	@Override
	protected boolean internalIsSet() {
		return description != null && description.isSet();
	}
}
