package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.datacollection.MethodologyBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.MaintainableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractVersionableBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.IdentifiedStructuredStringValueBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.ddi_3_1.util.URN;

public class MethodologyBeanImpl extends AbstractVersionableBeanImpl implements
		MethodologyBean {

	private IdentifiedStructuredStringValueBeanImpl dataCollectionMethodology;
	private IdentifiedStructuredStringValueBeanImpl deviationFromSample;
	private IdentifiedStructuredStringValueBeanImpl samplingProcedure;
	private IdentifiedStructuredStringValueBeanImpl timeMethod;

	private MaintainableBean parent;

	public MethodologyBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);

		dataCollectionMethodology = new IdentifiedStructuredStringValueBeanImpl(
				factory, this);

		deviationFromSample = new IdentifiedStructuredStringValueBeanImpl(
				factory, this);

		samplingProcedure = new IdentifiedStructuredStringValueBeanImpl(
				factory, this);

		timeMethod = new IdentifiedStructuredStringValueBeanImpl(factory, this);
	}

	@Override
	public IdentifiedStructuredStringValueBeanImpl getDataCollectionMethodology() {
		return dataCollectionMethodology;
	}

	@Override
	public IdentifiedStructuredStringValueBeanImpl getDeviationFromSampleDesign() {
		return deviationFromSample;
	}

	@Override
	public IdentifiedStructuredStringValueBeanImpl getSamplingProcedure() {
		return samplingProcedure;
	}

	@Override
	public IdentifiedStructuredStringValueBeanImpl getTimeMethod() {
		return timeMethod;
	}

	@Override
	protected void doChangeReference(IdentifiableBean toRemove,
			IdentifiableBean toAdd) {
		// TODO Auto-generated method stub
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		// TODO Auto-generated method stub
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.Methodology;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return MethodologyBean.class;
	}
}
