package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import java.util.Map;

import org.openmetadata.beans.ddi.lifecycle.datacollection.LiteralTextBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.StructuredStringBeanImpl;
import org.openmetadata.beans.notification.ChangeListener;

public class LiteralTextBeanImpl extends TextBeanImpl implements
		LiteralTextBean {
	private StructuredStringBeanImpl text;

	public LiteralTextBeanImpl(String language, Map<Enum<?>, Object> keyMap, DdiBeanFactory factory,
			ChangeListener listener) {
		super(factory, listener);
		text = new StructuredStringBeanImpl(language, keyMap, factory, this);
	}

	@Override
	public StructuredStringBeanImpl getText() {
		return text;
	}

	@Override
	protected boolean internalIsSet() {
		return text!=null && text.isSet();
	}
}
