package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.UserIDBean;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.notification.ChangeListener;

public class UserIDBeanImpl extends UnsettableDdiBeanImpl implements UserIDBean {

	private String stringValue = "";
	private String type;

	public UserIDBeanImpl(DdiBeanFactory factory, ChangeListener listener) {
		super(factory, listener);
	}

	public UserIDBeanImpl(String type, DdiBeanFactory beanFactory,
			ChangeListener listener) {
		super(beanFactory, listener);
		this.type = type;
	}

	@Override
	public String getStringValue() {
		return stringValue;
	}

	@Override
	public void setStringValue(String value) {
		if (CompareUtil.areDifferentValues(stringValue, value)) {
			stringValue = value;
			this.ddiBeanChanged();
		}
	}

	@Override
	public String getType() {
		return StringUtils.defaultString(type);
	}

	@Override
	public void setType(String value) {
		if (CompareUtil.areDifferentValues(type, value)) {
			type = value;
			this.ddiBeanChanged();
		}
	}

	@Override
	public boolean isSetType() {
		return type != null;
	}

	@Override
	public boolean internalIsSet() {
		return !StringUtils.isEmpty(stringValue);
	}

}
