package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.UnsettableDdiBean;
import org.openmetadata.beans.notification.ChangeListener;

public abstract class UnsettableDdiBeanImpl extends DdiBeanImpl implements
		UnsettableDdiBean {

	private boolean internal_empty = false;

	public UnsettableDdiBeanImpl(DdiBeanFactory beanFactory,
			ChangeListener changeListener) {
		super(beanFactory, beanFactory, changeListener);
		internal_empty = false;
	}

	@Override
	public final boolean isSet() {
		if(internal_empty){
			return false;
		}else{
			return internalIsSet();
		}
	}
	/**
	 * Subclasses must check if the children properties are empty 
	 * @return
	 */
	protected abstract boolean internalIsSet();
	
	@Override
	public final void unset() {
		internal_empty = true;
		this.doInternalUnset();
		this.ddiBeanChanged();
	}	
	
	protected void doInternalUnset(){
		// do nothing for default 
	}

	protected final void populate() {
		internal_empty = false;
	}
}
