package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.RepresentationBean;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.openmetadata.beans.notification.ChangeListener;

public abstract class RepresentationBeanImpl extends UnsettableDdiBeanImpl
		implements RepresentationBean {

	private boolean DEFAULT_BLANK_IS_MISSING_VALUE = false;

	private Boolean blankIsMissingValue;

	private CodeValueBeanImpl genericOutputFormat;
	private CodeValueBeanImpl recommendedDataType;

	boolean validating;

	public RepresentationBeanImpl(DdiBeanFactory factory,
			ChangeListener listener) {
		super(factory, listener);
	}

	@Override
	public boolean getBlankIsMissingValue() {
		if (isSetBlankIsMissingValue()) {
			return blankIsMissingValue;
		} else {
			return DEFAULT_BLANK_IS_MISSING_VALUE;
		}
	}

	@Override
	public void setBlankIsMissingValue(boolean blankIsMissingValue) {
		if (CompareUtil.areDifferentValues(this.blankIsMissingValue,
				blankIsMissingValue)) {
			this.blankIsMissingValue = blankIsMissingValue;
			populate();
			this.ddiBeanChanged();
		}
	}

	@Override
	public boolean isSetBlankIsMissingValue() {
		return blankIsMissingValue != null;
	}

	/*
	 * @Override public List getMissingValue() { // TODO Auto-generated method
	 * stub return null; }
	 */

	/*
	 * @Override public CategoryRelationCodeBean.Enum getClassificationLevel() {
	 * return null; }
	 */

	@Override
	public CodeValueBeanImpl getRecommendedDataType() {
		if (recommendedDataType == null) {
			recommendedDataType = new CodeValueBeanImpl(this.getBeanFactory(),
					this);
		}
		return recommendedDataType;
	}

	@Override
	public CodeValueBeanImpl getGenericOutputFormat() {
		if (genericOutputFormat == null) {
			genericOutputFormat = new CodeValueBeanImpl(this.getBeanFactory(),
					this);
		}
		return genericOutputFormat;
	}

	/*
	 * @Override public T getDdi3XmlObject() throws DdiValidationException { T
	 * rt = super.getDdi3XmlObject();
	 * 
	 * if (isSetBlankIsMissingValue()) {
	 * rt.setBlankIsMissingValue(getBlankIsMissingValue()); }else if
	 * (rt.isSetBlankIsMissingValue()) { rt.unsetBlankIsMissingValue(); }
	 * 
	 * //TODO: Populate missing values and classification level
	 * 
	 * if (!getGenericOutputFormat().isEmpty()) {
	 * rt.setGenericOutputFormat(getGenericOutputFormat().getDdi3XmlObject());
	 * }else if (rt.isSetGenericOutputFormat()) { rt.unsetGenericOutputFormat();
	 * }
	 * 
	 * if (!getRecommendedDataType().isEmpty()) {
	 * rt.setRecommendedDataType(getRecommendedDataType().getDdi3XmlObject());
	 * }else if (rt.isSetRecommendedDataType()) { rt.unsetRecommendedDataType();
	 * }
	 * 
	 * return rt; }
	 */

}
